/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.composite;

import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ua.tests.cheatsheet.util.MockTaskEditor;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetSaveHelper;
import org.eclipse.ui.internal.cheatsheets.composite.model.EditableTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskGroup;
import org.eclipse.ui.internal.cheatsheets.state.DefaultStateManager;
import org.eclipse.ui.internal.cheatsheets.state.ICheatSheetStateManager;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;
import org.eclipse.ui.internal.provisional.cheatsheets.IEditableTask;
import org.eclipse.ui.internal.provisional.cheatsheets.TaskEditor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPersistence {
    private static final String MEMENTO_TAG = "Mtag";
    private static final String PATH1 = "Path1";
    private static final String PATH2 = "Path2";
    private static final String KEY = "key";
    private static final String DATA1 = "1";
    private static final String DATA2 = "2";
    private CompositeCheatSheetModel model;
    private TaskGroup rootTask;
    private EditableTask task1;
    private EditableTask task2;
    private MockTaskEditor editor1;
    private MockTaskEditor editor2;
    private CompositeCheatSheetSaveHelper helper;

    private void createCompositeCheatSheet() {
        this.model = new CompositeCheatSheetModel("name", "description", "explorerId");
        this.model.setId("org.eclipse.ua.tests.testPersistence");
        this.rootTask = new TaskGroup(this.model, "root", "name", "kind");
        this.task1 = new EditableTask(this.model, "task1", "name", "kind");
        this.task2 = new EditableTask(this.model, "task2", "name", "kind");
        this.helper = new CompositeCheatSheetSaveHelper((ICheatSheetStateManager)new DefaultStateManager());
        this.model.setSaveHelper(this.helper);
        this.editor1 = new MockTaskEditor();
        this.editor2 = new MockTaskEditor();
        this.task1.setEditor((TaskEditor)this.editor1);
        this.task2.setEditor((TaskEditor)this.editor2);
        this.model.setRootTask((ICompositeCheatSheetTask)this.rootTask);
        this.rootTask.addSubtask((ICompositeCheatSheetTask)this.task1);
        this.rootTask.addSubtask((ICompositeCheatSheetTask)this.task2);
    }

    @Test
    public void testMementoSaveMultipleFiles() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)MEMENTO_TAG);
        memento.putString(KEY, DATA1);
        CheatSheetPlugin cheatSheetPlugin = CheatSheetPlugin.getPlugin();
        IStatus status = cheatSheetPlugin.saveMemento(memento, PATH1);
        Assertions.assertTrue((boolean)status.isOK());
        memento = XMLMemento.createWriteRoot((String)MEMENTO_TAG);
        memento.putString(KEY, DATA2);
        status = cheatSheetPlugin.saveMemento(memento, PATH2);
        Assertions.assertTrue((boolean)status.isOK());
        memento = cheatSheetPlugin.readMemento(PATH1);
        Assertions.assertEquals((Object)DATA1, (Object)memento.getString(KEY));
        memento = cheatSheetPlugin.readMemento(PATH2);
        Assertions.assertEquals((Object)DATA2, (Object)memento.getString(KEY));
    }

    @Test
    public void testSaveTaskState() {
        this.createCompositeCheatSheet();
        this.task1.setState(1);
        this.task2.setState(3);
        this.helper.saveCompositeState(this.model, null);
        this.createCompositeCheatSheet();
        this.model.loadState(new Hashtable());
        Assertions.assertEquals((int)1, (int)this.task1.getState());
        Assertions.assertEquals((int)3, (int)this.task2.getState());
    }

    @Test
    public void testSaveTaskMemento() {
        String value1 = "13579";
        String value2 = "AB24";
        this.createCompositeCheatSheet();
        this.task1.setState(3);
        this.task2.setState(1);
        this.editor1.setInput((IEditableTask)this.task1, null);
        this.editor2.setInput((IEditableTask)this.task2, null);
        Assertions.assertEquals((Object)"No Memento", (Object)this.editor1.getValue());
        Assertions.assertEquals((Object)"No Memento", (Object)this.editor2.getValue());
        this.editor1.setValue("13579");
        this.editor2.setValue("AB24");
        this.task1.setState(3);
        this.task2.setState(1);
        this.helper.saveCompositeState(this.model, null);
        this.createCompositeCheatSheet();
        this.model.loadState(new Hashtable());
        this.editor1.setInput((IEditableTask)this.task1, this.model.getTaskMemento(this.task1.getId()));
        this.editor2.setInput((IEditableTask)this.task2, this.model.getTaskMemento(this.task2.getId()));
        Assertions.assertEquals((Object)"13579", (Object)this.editor1.getValue());
        Assertions.assertEquals((Object)"AB24", (Object)this.editor2.getValue());
    }

    @Test
    public void testSaveLayoutData() {
        this.createCompositeCheatSheet();
        Hashtable<String, String> values = new Hashtable<String, String>();
        values.put("One", DATA1);
        values.put("Two", DATA2);
        this.helper.saveCompositeState(this.model, values);
        Hashtable restoredValues = new Hashtable();
        this.createCompositeCheatSheet();
        this.model.loadState(restoredValues);
        Assertions.assertEquals((int)2, (int)restoredValues.size());
        Assertions.assertEquals((Object)DATA1, values.get("One"));
        Assertions.assertEquals((Object)DATA2, values.get("Two"));
    }
}

