/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.composite;

import org.assertj.core.api.Assertions;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.model.EditableTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskGroup;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskStateUtilities;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestState {
    private CompositeCheatSheetModel model;

    @BeforeEach
    public void setUp() throws Exception {
        this.model = new CompositeCheatSheetModel("name", "description", "explorerId");
    }

    private void skip(ICompositeCheatSheetTask task) {
        ((AbstractTask)task).setState(2);
    }

    @Test
    public void testNoParent() {
        EditableTask task = new EditableTask(this.model, "id", "name", "ua.junit");
        org.junit.jupiter.api.Assertions.assertNull((Object)TaskStateUtilities.findSkippedAncestor((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertNull((Object)TaskStateUtilities.findCompletedAncestor((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertNull((Object)TaskStateUtilities.findBlockedAncestor((ICompositeCheatSheetTask)task));
    }

    @Test
    public void testSelfSkip() {
        EditableTask task = new EditableTask(this.model, "id", "name", "ua.junit");
        this.skip((ICompositeCheatSheetTask)task);
        org.junit.jupiter.api.Assertions.assertNull((Object)TaskStateUtilities.findSkippedAncestor((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertNull((Object)TaskStateUtilities.findCompletedAncestor((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertNull((Object)TaskStateUtilities.findBlockedAncestor((ICompositeCheatSheetTask)task));
    }

    @Test
    public void testSkippedParent() {
        TaskGroup root = new TaskGroup(this.model, "root", "rname", "sequence");
        TaskGroup group = new TaskGroup(this.model, "group", "gname", "sequence");
        EditableTask task = new EditableTask(this.model, "id", "name", "ua.junit");
        root.addSubtask((ICompositeCheatSheetTask)group);
        group.addSubtask((ICompositeCheatSheetTask)task);
        this.skip((ICompositeCheatSheetTask)root);
        this.skip((ICompositeCheatSheetTask)group);
        org.junit.jupiter.api.Assertions.assertEquals((Object)group, (Object)TaskStateUtilities.findSkippedAncestor((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertNull((Object)TaskStateUtilities.findBlockedAncestor((ICompositeCheatSheetTask)task));
    }

    @Test
    public void testSkippedGrandparent() {
        TaskGroup root = new TaskGroup(this.model, "root", "rname", "sequence");
        TaskGroup group = new TaskGroup(this.model, "group", "gname", "sequence");
        EditableTask task = new EditableTask(this.model, "id", "name", "ua.junit");
        root.addSubtask((ICompositeCheatSheetTask)group);
        group.addSubtask((ICompositeCheatSheetTask)task);
        this.skip((ICompositeCheatSheetTask)root);
        org.junit.jupiter.api.Assertions.assertEquals((Object)root, (Object)TaskStateUtilities.findSkippedAncestor((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertNull((Object)TaskStateUtilities.findBlockedAncestor((ICompositeCheatSheetTask)task));
    }

    @Test
    public void testCompletedGrandparent() {
        TaskGroup root = new TaskGroup(this.model, "root", "rname", "choice");
        TaskGroup group = new TaskGroup(this.model, "group", "gname", "sequence");
        EditableTask task = new EditableTask(this.model, "id", "name", "ua.junit");
        task.setSkippable(true);
        EditableTask completed = new EditableTask(this.model, "id2", "name2", "ua.junit");
        root.addSubtask((ICompositeCheatSheetTask)group);
        group.addSubtask((ICompositeCheatSheetTask)task);
        root.addSubtask((ICompositeCheatSheetTask)completed);
        org.junit.jupiter.api.Assertions.assertNull((Object)TaskStateUtilities.findCompletedAncestor((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertNull((Object)TaskStateUtilities.findBlockedAncestor((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertNull((Object)TaskStateUtilities.findSkippedAncestor((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TaskStateUtilities.isStartEnabled((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TaskStateUtilities.isSkipEnabled((ICompositeCheatSheetTask)task));
        completed.complete();
        org.junit.jupiter.api.Assertions.assertEquals((Object)root, (Object)TaskStateUtilities.findCompletedAncestor((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TaskStateUtilities.isStartEnabled((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TaskStateUtilities.isSkipEnabled((ICompositeCheatSheetTask)task));
    }

    @Test
    public void testBlockedGrandparent() {
        TaskGroup root = new TaskGroup(this.model, "root", "rname", "set");
        TaskGroup grandparent = new TaskGroup(this.model, "group1", "gname1", "sequence");
        TaskGroup parent = new TaskGroup(this.model, "group2", "gname2", "sequence");
        EditableTask task = new EditableTask(this.model, "id", "name", "ua.junit");
        task.setSkippable(true);
        EditableTask required = new EditableTask(this.model, "id2", "name2", "ua.junit");
        root.addSubtask((ICompositeCheatSheetTask)grandparent);
        grandparent.addSubtask((ICompositeCheatSheetTask)parent);
        parent.addSubtask((ICompositeCheatSheetTask)task);
        root.addSubtask((ICompositeCheatSheetTask)required);
        grandparent.addRequiredTask((AbstractTask)required);
        org.junit.jupiter.api.Assertions.assertNull((Object)TaskStateUtilities.findCompletedAncestor((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertNull((Object)TaskStateUtilities.findSkippedAncestor((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertEquals((Object)grandparent, (Object)TaskStateUtilities.findBlockedAncestor((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertNull((Object)TaskStateUtilities.findBlockedAncestor((ICompositeCheatSheetTask)grandparent));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TaskStateUtilities.isStartEnabled((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TaskStateUtilities.isSkipEnabled((ICompositeCheatSheetTask)task));
        required.complete();
        org.junit.jupiter.api.Assertions.assertNull((Object)TaskStateUtilities.findBlockedAncestor((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TaskStateUtilities.isStartEnabled((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TaskStateUtilities.isSkipEnabled((ICompositeCheatSheetTask)task));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TaskStateUtilities.isStartEnabled((ICompositeCheatSheetTask)parent));
    }

    @Test
    public void testRestartStates() {
        TaskGroup root = new TaskGroup(this.model, "root", "rname", "set");
        TaskGroup group = new TaskGroup(this.model, "group1", "gname", "set");
        EditableTask task1 = new EditableTask(this.model, "id1", "name1", "ua.junit");
        EditableTask task2 = new EditableTask(this.model, "id2", "name2", "ua.junit");
        EditableTask task3 = new EditableTask(this.model, "id3", "name3", "ua.junit");
        EditableTask task4 = new EditableTask(this.model, "id4", "name4", "ua.junit");
        task4.setSkippable(true);
        root.addSubtask((ICompositeCheatSheetTask)task1);
        root.addSubtask((ICompositeCheatSheetTask)task2);
        root.addSubtask((ICompositeCheatSheetTask)group);
        group.addSubtask((ICompositeCheatSheetTask)task3);
        group.addSubtask((ICompositeCheatSheetTask)task4);
        task1.setState(1);
        task2.setState(3);
        task4.setState(2);
        Assertions.assertThat((Object[])TaskStateUtilities.getRestartTasks((ICompositeCheatSheetTask)task1)).containsExactly((Object[])new AbstractTask[]{task1});
        Assertions.assertThat((Object[])TaskStateUtilities.getRestartTasks((ICompositeCheatSheetTask)task2)).hasSize(1);
        Assertions.assertThat((Object[])TaskStateUtilities.getRestartTasks((ICompositeCheatSheetTask)task3)).isEmpty();
        Assertions.assertThat((Object[])TaskStateUtilities.getRestartTasks((ICompositeCheatSheetTask)task4)).hasSize(1);
        Assertions.assertThat((Object[])TaskStateUtilities.getRestartTasks((ICompositeCheatSheetTask)group)).containsExactly((Object[])new AbstractTask[]{task4});
        Assertions.assertThat((Object[])TaskStateUtilities.getRestartTasks((ICompositeCheatSheetTask)root)).hasSize(3);
    }

    @Test
    public void testResetDependents() {
        TaskGroup root = new TaskGroup(this.model, "root", "rname", "set");
        TaskGroup group = new TaskGroup(this.model, "group1", "gname", "set");
        TaskGroup subGroup = new TaskGroup(this.model, "group2", "gname2", "set");
        EditableTask task1 = new EditableTask(this.model, "id1", "name1", "ua.junit");
        EditableTask task2 = new EditableTask(this.model, "id2", "name2", "ua.junit");
        EditableTask task3 = new EditableTask(this.model, "id3", "name3", "ua.junit");
        EditableTask task4 = new EditableTask(this.model, "id4", "name4", "ua.junit");
        EditableTask task5 = new EditableTask(this.model, "id5", "name5", "ua.junit");
        task2.addRequiredTask((AbstractTask)task1);
        task3.addRequiredTask((AbstractTask)task2);
        subGroup.addRequiredTask((AbstractTask)task3);
        task4.addRequiredTask((AbstractTask)subGroup);
        root.addSubtask((ICompositeCheatSheetTask)group);
        group.addSubtask((ICompositeCheatSheetTask)task1);
        group.addSubtask((ICompositeCheatSheetTask)task2);
        group.addSubtask((ICompositeCheatSheetTask)task3);
        group.addSubtask((ICompositeCheatSheetTask)subGroup);
        group.addSubtask((ICompositeCheatSheetTask)task4);
        subGroup.addSubtask((ICompositeCheatSheetTask)task5);
        task1.complete();
        task2.complete();
        task3.complete();
        task5.setStarted();
        Assertions.assertThat((Object[])TaskStateUtilities.getRestartTasks((ICompositeCheatSheetTask)root)).hasSize(4);
        Assertions.assertThat((Object[])TaskStateUtilities.getRestartTasks((ICompositeCheatSheetTask)task1)).hasSize(4);
        Assertions.assertThat((Object[])TaskStateUtilities.getRestartTasks((ICompositeCheatSheetTask)task2)).hasSize(3);
        Assertions.assertThat((Object[])TaskStateUtilities.getRestartTasks((ICompositeCheatSheetTask)task3)).hasSize(2);
        Assertions.assertThat((Object[])TaskStateUtilities.getRestartTasks((ICompositeCheatSheetTask)subGroup)).hasSize(1);
        task5.setState(0);
        task3.setState(0);
        task2.setState(0);
        task2.setState(2);
        task3.setStarted();
        Assertions.assertThat((Object[])TaskStateUtilities.getRestartTasks((ICompositeCheatSheetTask)root)).hasSize(3);
        Assertions.assertThat((Object[])TaskStateUtilities.getRestartTasks((ICompositeCheatSheetTask)task1)).hasSize(1);
        Assertions.assertThat((Object[])TaskStateUtilities.getRestartTasks((ICompositeCheatSheetTask)task2)).hasSize(2);
    }
}

