/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.composite;

import org.assertj.core.api.Assertions;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.model.EditableTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.SuccesorTaskFinder;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskGroup;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;
import org.junit.jupiter.api.Test;

public class TestSuccessors {
    private CompositeCheatSheetModel model;
    private TaskGroup rootTask;
    private TaskGroup subGroup;
    private EditableTask task1;
    private EditableTask task2;
    private EditableTask task3;
    private EditableTask task4;

    private void setupModel(boolean subGroupIsChoice) {
        this.model = new CompositeCheatSheetModel("name", "description", "explorerId");
        this.model.setId("org.eclipse.ua.tests.testPersistence");
        this.rootTask = new TaskGroup(this.model, "root", "name", "set");
        String subgroupKind = "set";
        if (subGroupIsChoice) {
            subgroupKind = "choice";
        }
        this.subGroup = new TaskGroup(this.model, "subGroup", "name", subgroupKind);
        this.task1 = new EditableTask(this.model, "task1", "name", "ua.junit");
        this.task2 = new EditableTask(this.model, "task2", "name", "ua.junit");
        this.task3 = new EditableTask(this.model, "task3", "name", "ua.junit");
        this.task4 = new EditableTask(this.model, "task4", "name", "ua.junit");
        this.model.setRootTask((ICompositeCheatSheetTask)this.rootTask);
        this.rootTask.addSubtask((ICompositeCheatSheetTask)this.subGroup);
        this.rootTask.addSubtask((ICompositeCheatSheetTask)this.task4);
        this.subGroup.addSubtask((ICompositeCheatSheetTask)this.task1);
        this.subGroup.addSubtask((ICompositeCheatSheetTask)this.task2);
        this.subGroup.addSubtask((ICompositeCheatSheetTask)this.task3);
    }

    private void assertSingleSuccessor(ICompositeCheatSheetTask task, ICompositeCheatSheetTask expectedSuccessor) {
        SuccesorTaskFinder finder = new SuccesorTaskFinder(task);
        Object[] successors = finder.getRecommendedSuccessors();
        Assertions.assertThat((Object[])successors).containsExactly((Object[])new ICompositeCheatSheetTask[]{expectedSuccessor});
    }

    private void assertNoSuccessors(ICompositeCheatSheetTask task) {
        SuccesorTaskFinder finder = new SuccesorTaskFinder(task);
        Object[] successors = finder.getRecommendedSuccessors();
        Assertions.assertThat((Object[])successors).isEmpty();
    }

    @Test
    public void testSuccessorsCleanModel() {
        this.setupModel(false);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.rootTask, (ICompositeCheatSheetTask)this.subGroup);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.subGroup, (ICompositeCheatSheetTask)this.task1);
    }

    @Test
    public void testSuccessorsFirstTaskInProgress() {
        this.setupModel(false);
        this.task1.setState(1);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.rootTask, (ICompositeCheatSheetTask)this.subGroup);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.subGroup, (ICompositeCheatSheetTask)this.task1);
    }

    @Test
    public void testSuccessorsFirstTaskSkipped() {
        this.setupModel(false);
        this.task1.setState(2);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.rootTask, (ICompositeCheatSheetTask)this.subGroup);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.subGroup, (ICompositeCheatSheetTask)this.task2);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.task1, (ICompositeCheatSheetTask)this.task2);
    }

    @Test
    public void testSuccessorsFirstTaskCompleted() {
        this.setupModel(false);
        this.task1.complete();
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.rootTask, (ICompositeCheatSheetTask)this.subGroup);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.subGroup, (ICompositeCheatSheetTask)this.task2);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.task1, (ICompositeCheatSheetTask)this.task2);
    }

    @Test
    public void testSuccessorsWithBackwardDependency() {
        this.setupModel(false);
        this.task1.addRequiredTask((AbstractTask)this.task3);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.subGroup, (ICompositeCheatSheetTask)this.task2);
        this.task2.complete();
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.subGroup, (ICompositeCheatSheetTask)this.task3);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.task2, (ICompositeCheatSheetTask)this.task3);
    }

    @Test
    public void testCompleteGroup() {
        this.setupModel(false);
        this.task1.complete();
        this.task2.complete();
        this.task3.complete();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.subGroup.getState());
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.rootTask, (ICompositeCheatSheetTask)this.task4);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.subGroup, (ICompositeCheatSheetTask)this.task4);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.task1, (ICompositeCheatSheetTask)this.task4);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.task2, (ICompositeCheatSheetTask)this.task4);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.task3, (ICompositeCheatSheetTask)this.task4);
    }

    @Test
    public void testAllTasksComplete() {
        this.setupModel(false);
        this.task1.complete();
        this.task2.complete();
        this.task3.complete();
        this.task4.complete();
        this.assertNoSuccessors((ICompositeCheatSheetTask)this.rootTask);
        this.assertNoSuccessors((ICompositeCheatSheetTask)this.subGroup);
        this.assertNoSuccessors((ICompositeCheatSheetTask)this.task1);
        this.assertNoSuccessors((ICompositeCheatSheetTask)this.task4);
    }

    @Test
    public void testUnstartedChoice() {
        this.setupModel(true);
        SuccesorTaskFinder finder = new SuccesorTaskFinder((ICompositeCheatSheetTask)this.subGroup);
        Object[] successors = finder.getRecommendedSuccessors();
        Assertions.assertThat((Object[])successors).containsExactly((Object[])new ICompositeCheatSheetTask[]{this.task1, this.task2, this.task3});
    }

    @Test
    public void testCompletedChoice() {
        this.setupModel(true);
        this.task1.complete();
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.rootTask, (ICompositeCheatSheetTask)this.task4);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.subGroup, (ICompositeCheatSheetTask)this.task4);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.task1, (ICompositeCheatSheetTask)this.task4);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.task2, (ICompositeCheatSheetTask)this.task4);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.task3, (ICompositeCheatSheetTask)this.task4);
    }

    @Test
    public void testSkippedGroup() {
        this.setupModel(false);
        this.task1.complete();
        this.subGroup.setSkippable(true);
        this.subGroup.setState(2);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.rootTask, (ICompositeCheatSheetTask)this.task4);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.subGroup, (ICompositeCheatSheetTask)this.task4);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.task1, (ICompositeCheatSheetTask)this.task4);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.task2, (ICompositeCheatSheetTask)this.task4);
        this.assertSingleSuccessor((ICompositeCheatSheetTask)this.task3, (ICompositeCheatSheetTask)this.task4);
    }
}

