/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.composite;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.model.EditableTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskGroup;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestTaskEvents {
    private CompositeCheatSheetModel model;
    private TaskGroup rootTask;
    private TaskGroup group1;
    private TaskGroup group2;
    private EditableTask task1A;
    private EditableTask task1B;
    private EditableTask task1C;
    private EditableTask task2A;
    private EditableTask task2B;
    private EditableTask task3A;
    private TaskMap taskMap;
    private static final int IN_PROGRESS = 1;
    private static final int COMPLETED = 3;
    private static final int SKIPPED = 2;

    protected void createModel(String rootKind, String group1Kind, String group2Kind) {
        this.model = new CompositeCheatSheetModel("name", "description", "explorerId");
        this.rootTask = new TaskGroup(this.model, "root", "name", rootKind);
        this.group1 = new TaskGroup(this.model, "group1", "group1", group1Kind);
        this.group2 = new TaskGroup(this.model, "group2", "group2", group1Kind);
        this.task1A = new EditableTask(this.model, "task1A", "name", "kind");
        this.task1B = new EditableTask(this.model, "task1B", "name", "kind");
        this.task1C = new EditableTask(this.model, "task1C", "name", "kind");
        this.task2A = new EditableTask(this.model, "task2A", "name", "kind");
        this.task2B = new EditableTask(this.model, "task2B", "name", "kind");
        this.task3A = new EditableTask(this.model, "task3A", "name", "kind");
        this.model.setRootTask((ICompositeCheatSheetTask)this.rootTask);
        this.rootTask.addSubtask((ICompositeCheatSheetTask)this.group1);
        this.rootTask.addSubtask((ICompositeCheatSheetTask)this.group2);
        this.rootTask.addSubtask((ICompositeCheatSheetTask)this.task3A);
        this.group1.addSubtask((ICompositeCheatSheetTask)this.task1A);
        this.group1.addSubtask((ICompositeCheatSheetTask)this.task1B);
        this.group1.addSubtask((ICompositeCheatSheetTask)this.task1C);
        this.group2.addSubtask((ICompositeCheatSheetTask)this.task2A);
        this.group2.addSubtask((ICompositeCheatSheetTask)this.task2B);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.resetTaskMap();
    }

    private void resetTaskMap() {
        this.taskMap = new TaskMap();
    }

    @Test
    public void testStartTask() {
        this.createModel("set", "sequence", "choice");
        this.model.addObserver((Observer)new ModelObserver());
        this.task1A.setState(1);
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1A));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.rootTask));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.group1));
        Assertions.assertEquals((int)3, (int)this.taskMap.getTotalEventCount());
    }

    @Test
    public void testStartTwoTasks() {
        this.createModel("set", "sequence", "choice");
        this.model.addObserver((Observer)new ModelObserver());
        this.task1A.setState(1);
        this.task1B.setState(1);
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1A));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1B));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.rootTask));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.group1));
        Assertions.assertEquals((int)4, (int)this.taskMap.getTotalEventCount());
    }

    @Test
    public void testCompleteTaskGroup() {
        this.createModel("set", "sequence", "choice");
        this.model.addObserver((Observer)new ModelObserver());
        this.task1A.setState(3);
        this.task1B.setState(3);
        this.task1C.setState(3);
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1A));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1B));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1C));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.rootTask));
        Assertions.assertEquals((int)2, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.group1));
        Assertions.assertEquals((int)6, (int)this.taskMap.getTotalEventCount());
    }

    @Test
    public void testCompleteTaskWithDependent() {
        this.createModel("set", "sequence", "choice");
        this.task1B.addRequiredTask((AbstractTask)this.task1A);
        this.model.addObserver((Observer)new ModelObserver());
        this.task1A.setState(3);
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1A));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1B));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.rootTask));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.group1));
        Assertions.assertEquals((int)4, (int)this.taskMap.getTotalEventCount());
    }

    @Test
    public void testResetSingleTask() {
        this.createModel("set", "sequence", "choice");
        this.model.addObserver((Observer)new ModelObserver());
        this.task1A.setState(3);
        this.task1B.setState(3);
        this.resetTaskMap();
        this.model.resetTasks(new ICompositeCheatSheetTask[]{this.task1A});
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1A));
        Assertions.assertEquals((int)1, (int)this.taskMap.getTotalEventCount());
    }

    @Test
    public void testResetTaskWithDependent() {
        this.createModel("set", "sequence", "choice");
        this.model.addObserver((Observer)new ModelObserver());
        this.task1B.addRequiredTask((AbstractTask)this.task1A);
        this.task1A.setState(3);
        this.resetTaskMap();
        this.model.resetTasks(new ICompositeCheatSheetTask[]{this.task1A});
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1A));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1B));
    }

    @Test
    public void testResetSingleTaskInCompleteSet() {
        this.createModel("set", "sequence", "choice");
        this.model.addObserver((Observer)new ModelObserver());
        this.task1A.setState(3);
        this.task1B.setState(3);
        this.task1C.setState(3);
        this.resetTaskMap();
        this.model.resetTasks(new ICompositeCheatSheetTask[]{this.task1A});
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1A));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.group1));
        Assertions.assertEquals((int)2, (int)this.taskMap.getTotalEventCount());
    }

    @Test
    public void testResetTwoTasksInCompleteSet() {
        this.createModel("set", "sequence", "choice");
        this.model.addObserver((Observer)new ModelObserver());
        this.task1A.setState(3);
        this.task1B.setState(3);
        this.task1C.setState(3);
        this.resetTaskMap();
        this.model.resetTasks(new ICompositeCheatSheetTask[]{this.task1A, this.task1B});
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1A));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1B));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.group1));
        Assertions.assertEquals((int)3, (int)this.taskMap.getTotalEventCount());
    }

    @Test
    public void testResetAllTasksInCompleteSet() {
        this.createModel("set", "sequence", "choice");
        this.model.addObserver((Observer)new ModelObserver());
        this.task1A.setState(3);
        this.task1B.setState(3);
        this.task1C.setState(3);
        this.resetTaskMap();
        this.model.resetTasks(new ICompositeCheatSheetTask[]{this.task1A, this.task1B, this.task1C});
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1A));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1B));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1C));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.group1));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.rootTask));
    }

    @Test
    public void testResetSingleTaskInCompleteChoice() {
        this.createModel("set", "choice", "choice");
        this.model.addObserver((Observer)new ModelObserver());
        this.task1A.setState(3);
        this.resetTaskMap();
        this.model.resetTasks(new ICompositeCheatSheetTask[]{this.task1A});
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1A));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1B));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1C));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.group1));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.rootTask));
    }

    @Test
    public void testResetGroupWithTwoStartedTasks() {
        this.createModel("set", "sequence", "choice");
        this.model.addObserver((Observer)new ModelObserver());
        this.task1A.setState(3);
        this.task1B.setState(3);
        this.task3A.setState(1);
        this.resetTaskMap();
        this.model.resetTasks(new ICompositeCheatSheetTask[]{this.group1});
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1A));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1B));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.group1));
        Assertions.assertEquals((int)4, (int)this.taskMap.getTotalEventCount());
    }

    @Test
    public void testCompleteChoice() {
        this.createModel("set", "choice", "choice");
        this.model.addObserver((Observer)new ModelObserver());
        this.task1A.setState(3);
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1A));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1B));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1C));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.group1));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.rootTask));
        Assertions.assertEquals((int)5, (int)this.taskMap.getTotalEventCount());
    }

    @Test
    public void testCompleteGroupWithDependentGroup() {
        this.createModel("set", "choice", "choice");
        this.group2.addRequiredTask((AbstractTask)this.group1);
        this.model.addObserver((Observer)new ModelObserver());
        this.task1A.setState(3);
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1A));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1B));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1C));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.group1));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task2A));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task2B));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.group2));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.rootTask));
        Assertions.assertEquals((int)8, (int)this.taskMap.getTotalEventCount());
    }

    @Test
    public void testSkipTaskGroup() {
        this.createModel("set", "choice", "choice");
        this.model.addObserver((Observer)new ModelObserver());
        this.group1.setState(2);
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1A));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1B));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.task1C));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.group1));
        Assertions.assertEquals((int)1, (int)this.taskMap.getEventCount((ICompositeCheatSheetTask)this.rootTask));
        Assertions.assertEquals((int)5, (int)this.taskMap.getTotalEventCount());
    }

    public class ModelObserver
    implements Observer {
        @Override
        public void update(Observable o, Object arg) {
            TestTaskEvents.this.taskMap.put((ICompositeCheatSheetTask)arg);
        }
    }

    public static class TaskCounter {
        private int count = 1;

        public int getCount() {
            return this.count;
        }

        public void incrementCount() {
            ++this.count;
        }
    }

    public static class TaskMap {
        private final Map<String, TaskCounter> map = new HashMap<String, TaskCounter>();
        private int eventCount = 0;

        public void put(ICompositeCheatSheetTask task) {
            String id = task.getId();
            if (this.map.containsKey(id)) {
                this.map.get(id).incrementCount();
            } else {
                this.map.put(id, new TaskCounter());
            }
            ++this.eventCount;
        }

        public int getEventCount(ICompositeCheatSheetTask task) {
            String id = task.getId();
            if (this.map.containsKey(id)) {
                return this.map.get(id).getCount();
            }
            return 0;
        }

        public int getTotalEventCount() {
            return this.eventCount;
        }
    }
}

