/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.composite;

import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.model.EditableTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskGroup;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTaskGroups {
    private static final int NOT_STARTED = 0;
    private static final int IN_PROGRESS = 1;
    private static final int SKIPPED = 2;
    private static final int COMPLETED = 3;

    private int getGroupState(String kind, int[] childStates) {
        CompositeCheatSheetModel model = new CompositeCheatSheetModel("name", "desc", null);
        TaskGroup group = new TaskGroup(model, "id", "name", kind);
        int i = 0;
        while (i < childStates.length) {
            EditableTask editable = new EditableTask(model, "id" + i, "name" + i, "editableKind");
            group.addSubtask((ICompositeCheatSheetTask)editable);
            editable.setState(childStates[i]);
            ++i;
        }
        return group.computeState();
    }

    @Test
    public void testEmptySet() {
        Assertions.assertEquals((int)3, (int)this.getGroupState("set", new int[0]));
    }

    @Test
    public void testSetNotStarted() {
        Assertions.assertEquals((int)0, (int)this.getGroupState("set", new int[2]));
    }

    @Test
    public void testSetInProgress() {
        Assertions.assertEquals((int)1, (int)this.getGroupState("set", new int[]{1}));
    }

    @Test
    public void testSetPartiallyComplete() {
        int[] nArray = new int[2];
        nArray[0] = 3;
        Assertions.assertEquals((int)1, (int)this.getGroupState("set", nArray));
    }

    @Test
    public void testSetCompleted() {
        Assertions.assertEquals((int)3, (int)this.getGroupState("set", new int[]{3, 2}));
    }

    @Test
    public void testEmptySequence() {
        Assertions.assertEquals((int)3, (int)this.getGroupState("sequence", new int[0]));
    }

    @Test
    public void testSequenceNotStarted() {
        Assertions.assertEquals((int)0, (int)this.getGroupState("sequence", new int[2]));
    }

    @Test
    public void testSequenceInProgress() {
        Assertions.assertEquals((int)1, (int)this.getGroupState("sequence", new int[]{1}));
    }

    @Test
    public void testSequencePartiallyComplete() {
        int[] nArray = new int[2];
        nArray[0] = 3;
        Assertions.assertEquals((int)1, (int)this.getGroupState("sequence", nArray));
    }

    @Test
    public void testSequenceCompleted() {
        Assertions.assertEquals((int)3, (int)this.getGroupState("sequence", new int[]{3, 2}));
    }

    @Test
    public void testSequenceSkipped() {
        Assertions.assertEquals((int)3, (int)this.getGroupState("sequence", new int[]{2, 2}));
    }

    @Test
    public void testEmptyChoice() {
        Assertions.assertEquals((int)3, (int)this.getGroupState("choice", new int[0]));
    }

    @Test
    public void testChoiceNotStarted() {
        Assertions.assertEquals((int)0, (int)this.getGroupState("choice", new int[2]));
    }

    @Test
    public void testSingleChoiceNotStarted() {
        Assertions.assertEquals((int)0, (int)this.getGroupState("choice", new int[1]));
    }

    @Test
    public void testChoiceInProgress() {
        Assertions.assertEquals((int)1, (int)this.getGroupState("choice", new int[]{1}));
    }

    @Test
    public void testChoicePartiallyComplete() {
        int[] nArray = new int[2];
        nArray[0] = 3;
        Assertions.assertEquals((int)3, (int)this.getGroupState("choice", nArray));
    }

    @Test
    public void testChoiceCompleted() {
        Assertions.assertEquals((int)3, (int)this.getGroupState("choice", new int[]{3, 2}));
    }

    @Test
    public void testSingleChoiceCompleted() {
        Assertions.assertEquals((int)3, (int)this.getGroupState("choice", new int[]{3}));
    }

    @Test
    public void testChoiceSkipped() {
        int[] nArray = new int[2];
        nArray[1] = 2;
        Assertions.assertEquals((int)3, (int)this.getGroupState("choice", nArray));
    }
}

