/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.execution;

import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ua.tests.cheatsheet.execution.ActionEnvironment;
import org.eclipse.ui.internal.cheatsheets.ActionRunner;
import org.eclipse.ui.internal.cheatsheets.data.Action;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.FrameworkUtil;

public class TestActionExecution {
    private static final String ACTION_PACKAGE = "org.eclipse.ua.tests.cheatsheet.execution";
    private static final String SIMPLE_ACTION_CLASS = "org.eclipse.ua.tests.cheatsheet.execution.SimpleAction";
    private static final String FAILING_ACTION_CLASS = "org.eclipse.ua.tests.cheatsheet.execution.FailingAction";
    private static final String ACTION_WITH_PARAMETERS_CLASS = "org.eclipse.ua.tests.cheatsheet.execution.ActionWithParameters";

    @BeforeEach
    public void setUp() throws Exception {
        ActionEnvironment.reset();
    }

    @AfterAll
    public static void tearDown() throws Exception {
        ActionEnvironment.reset();
    }

    @Test
    public void testSimpleAction() {
        Action action = new Action();
        action.setClass(SIMPLE_ACTION_CLASS);
        action.setParams(new String[0]);
        action.setPluginID(this.getPluginId());
        IStatus status = new ActionRunner().runAction(action, null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)status.isOK());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)ActionEnvironment.getTimesCompleted());
    }

    @Test
    public void testInvalidAction() {
        Action action = new Action();
        action.setClass("org.eclipse.ua.tests.cheatsheet.execution.SimpleActioninvalid");
        action.setParams(new String[0]);
        action.setPluginID(this.getPluginId());
        IStatus status = new ActionRunner().runAction(action, null);
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)status.getSeverity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ActionEnvironment.getTimesCompleted());
    }

    @Test
    public void testSimpleActionWithException() {
        Action action = new Action();
        action.setClass(SIMPLE_ACTION_CLASS);
        action.setParams(new String[0]);
        action.setPluginID(this.getPluginId());
        ActionEnvironment.setThrowException(true);
        IStatus status = new ActionRunner().runAction(action, null);
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)status.getSeverity());
        org.junit.jupiter.api.Assertions.assertEquals(RuntimeException.class, status.getException().getClass());
    }

    @Test
    public void testFailingAction() {
        Action action = new Action();
        action.setClass(FAILING_ACTION_CLASS);
        action.setParams(new String[0]);
        action.setPluginID(this.getPluginId());
        IStatus status = new ActionRunner().runAction(action, null);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)status.getSeverity());
    }

    @Test
    public void testActionWithParameters() {
        Action action = new Action();
        action.setClass(ACTION_WITH_PARAMETERS_CLASS);
        String value0 = "abc";
        String value1 = "defg";
        String[] params = new String[]{value0, value1};
        action.setParams(params);
        action.setPluginID(this.getPluginId());
        IStatus status = new ActionRunner().runAction(action, null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)status.isOK());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)ActionEnvironment.getTimesCompleted());
        Object[] actuals = ActionEnvironment.getParams();
        Assertions.assertThat((Object[])actuals).containsExactly((Object[])new String[]{value0, value1});
    }

    private String getPluginId() {
        return FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
    }
}

