/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.execution;

import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.SerializationException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ua.tests.cheatsheet.execution.CommandHandler;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.cheatsheets.CommandRunner;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetCommand;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestCommandExecution {
    private static final String PARAM2_VALUE = "bar";
    private static final String PARAM1_VALUE = "foo";
    private static final String PARAM1_ID = "param1_id";
    private static final String PARAM2_ID = "param2_id";
    private static final String COMMAND_ID = "org.eclipse.ui.cheatsheets.tests.command1";
    private static final String SERIALIZED_COMMAND = "org.eclipse.ui.cheatsheets.tests.command1(param1_id=foo,param2_id=bar)";
    private static final String RETURN_STORE = "retData";
    private static final String PARENT_RETURN_STORE = "parent.retData";
    private static final String NEGATE_INTEGER_COMMAND_ID = "org.eclipse.ui.cheatsheets.tests.NegateIntegerCommand(number=123)";
    private static final String INT_RETURN_STORE = "intData";

    @BeforeEach
    public void setUp() throws Exception {
        CommandHandler.reset();
    }

    public CheatSheetManager createManager() {
        CheatSheetElement element = new CheatSheetElement("Name");
        element.setID("TestCommandExecutionId");
        return new CheatSheetManager(element);
    }

    private ICommandService getService() {
        IWorkbench wb = PlatformUI.getWorkbench();
        Object serviceObject = wb.getAdapter(ICommandService.class);
        if (serviceObject != null) {
            ICommandService service = (ICommandService)serviceObject;
            return service;
        }
        return null;
    }

    private IHandlerService getHandlerService() {
        Object serviceObject;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (serviceObject = wb.getAdapter(IHandlerService.class)) != null) {
            IHandlerService service = (IHandlerService)serviceObject;
            return service;
        }
        return null;
    }

    @Test
    public void testExecuteCommand() {
        try {
            ParameterizedCommand selectedCommand = this.getService().deserialize(SERIALIZED_COMMAND);
            this.getHandlerService().executeCommand(selectedCommand, null);
        }
        catch (NotDefinedException e) {
            Assertions.fail((String)"Command not defined");
        }
        catch (SerializationException e) {
            Assertions.fail((String)"Bad serialization");
        }
        catch (ExecutionException e) {
            Assertions.fail((String)"Execution exception");
        }
        catch (NotEnabledException e) {
            Assertions.fail((String)"Not enabled exception");
        }
        catch (NotHandledException e) {
            Assertions.fail((String)"Not handled exception");
        }
        this.checkCommandExecution();
    }

    private void checkCommandExecution() {
        Assertions.assertTrue((CommandHandler.getTimesCompleted() == 1 ? 1 : 0) != 0);
        Map<String, String> params = CommandHandler.getParams();
        Assertions.assertEquals((int)2, (int)params.size());
        Assertions.assertTrue((boolean)params.containsKey(PARAM1_ID));
        Assertions.assertEquals((Object)PARAM1_VALUE, (Object)params.get(PARAM1_ID));
        Assertions.assertTrue((boolean)params.containsKey(PARAM2_ID));
        Assertions.assertEquals((Object)PARAM2_VALUE, (Object)params.get(PARAM2_ID));
    }

    @Test
    public void testCommandRunner() {
        CheatSheetCommand command = new CheatSheetCommand();
        CheatSheetManager csm = this.createManager();
        command.setSerialization(SERIALIZED_COMMAND);
        IStatus status = new CommandRunner().executeCommand(command, csm);
        Assertions.assertTrue((boolean)status.isOK());
        this.checkCommandExecution();
    }

    @Test
    public void testCommandWithResult() {
        CheatSheetCommand command = new CheatSheetCommand();
        CheatSheetManager csm = this.createManager();
        command.setSerialization(SERIALIZED_COMMAND);
        command.setReturns(RETURN_STORE);
        IStatus status = new CommandRunner().executeCommand(command, csm);
        Assertions.assertTrue((boolean)status.isOK());
        String result = csm.getData(RETURN_STORE);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"RESULT_TO_STRING", (Object)result);
        this.checkCommandExecution();
    }

    @Test
    public void testCommandWithQualifiedResult() {
        CheatSheetCommand command = new CheatSheetCommand();
        CheatSheetManager csm = this.createManager();
        CheatSheetManager parentManager = this.createManager();
        csm.setParent((ICheatSheetManager)parentManager);
        command.setSerialization(SERIALIZED_COMMAND);
        command.setReturns(PARENT_RETURN_STORE);
        IStatus status = new CommandRunner().executeCommand(command, csm);
        Assertions.assertTrue((boolean)status.isOK());
        Assertions.assertNull((Object)csm.getData(RETURN_STORE));
        Assertions.assertNotNull((Object)parentManager.getData(RETURN_STORE));
    }

    @Test
    public void testInvalidCommandId() {
        CheatSheetCommand command = new CheatSheetCommand();
        CheatSheetManager csm = this.createManager();
        command.setSerialization("org.eclipse.ui.cheatsheets.tests.command1.invalid");
        IStatus status = new CommandRunner().executeCommand(command, csm);
        Assertions.assertFalse((boolean)status.isOK());
    }

    @Test
    public void testCommandException() {
        CheatSheetCommand command = new CheatSheetCommand();
        CheatSheetManager csm = this.createManager();
        command.setSerialization(SERIALIZED_COMMAND);
        CommandHandler.setThrowException(true);
        IStatus status = new CommandRunner().executeCommand(command, csm);
        Assertions.assertFalse((boolean)status.isOK());
    }

    @Test
    public void testCommandWithIntegerValues() {
        CheatSheetCommand command = new CheatSheetCommand();
        CheatSheetManager csm = this.createManager();
        command.setSerialization(NEGATE_INTEGER_COMMAND_ID);
        command.setReturns(INT_RETURN_STORE);
        IStatus status = new CommandRunner().executeCommand(command, csm);
        Assertions.assertTrue((boolean)status.isOK());
        String result = csm.getData(INT_RETURN_STORE);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"-123", (Object)result);
    }
}

