/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.execution;

import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestVariableSubstitution {
    private CheatSheetManager manager;

    @BeforeEach
    public void setUp() throws Exception {
        this.manager = new CheatSheetManager(new CheatSheetElement("name"));
        this.manager.setData("p1", "one");
        this.manager.setData("p2", "two");
    }

    private String substitute(String input) {
        return this.manager.performVariableSubstitution(input);
    }

    @Test
    public void testNoSubstitution() {
        Assertions.assertEquals((Object)"abcdefg", (Object)this.substitute("abcdefg"));
    }

    @Test
    public void testFullString() {
        Assertions.assertEquals((Object)"one", (Object)this.substitute("${p1}"));
    }

    @Test
    public void testEmbeddedString() {
        Assertions.assertEquals((Object)"AoneB", (Object)this.substitute("A${p1}B"));
    }

    @Test
    public void testRepeatedSubstitution() {
        Assertions.assertEquals((Object)"oneXone", (Object)this.substitute("${p1}X${p1}"));
    }

    @Test
    public void testMultipleSubstitution() {
        Assertions.assertEquals((Object)"onetwo", (Object)this.substitute("${p1}${p2}"));
    }

    @Test
    public void testNonexistentParameter() {
        Assertions.assertEquals((Object)"one", (Object)this.substitute("${p1}${p3}"));
    }

    @Test
    public void testUnterminatedParameter() {
        Assertions.assertEquals((Object)"${p1", (Object)"${p1");
    }
}

