/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.other;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetCollectionElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.junit.jupiter.api.Test;

public class TestCheatSheetCategories {
    private static final String TEST_CATEGORY = "org.eclipse.ua.tests.cheatsheet.cheatSheetsTestCat";

    @Test
    public void testForCollection() {
        Object[] subCategories;
        CheatSheetCollectionElement cheatSheets = CheatSheetRegistryReader.getInstance().getCheatSheets();
        Object[] objectArray = subCategories = cheatSheets.getChildren();
        int n = subCategories.length;
        int n2 = 0;
        while (n2 < n) {
            Object subCategorie = objectArray[n2];
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(subCategorie instanceof CheatSheetCollectionElement));
            ++n2;
        }
    }

    @Test
    public void testFindTestCategory() {
        CheatSheetCollectionElement cheatSheets = CheatSheetRegistryReader.getInstance().getCheatSheets();
        CheatSheetCollectionElement testCat = this.findChildCategory(cheatSheets, TEST_CATEGORY);
        ((ObjectAssert)Assertions.assertThat((Object)testCat).as("cannot find category org.eclipse.ua.tests.cheatsheet.cheatSheetsTestCat", new Object[0])).isNotNull();
    }

    @Test
    public void testFindQualifiedSubcategory() {
        CheatSheetCollectionElement cheatSheets = CheatSheetRegistryReader.getInstance().getCheatSheets();
        CheatSheetCollectionElement testCat = this.findChildCategory(cheatSheets, TEST_CATEGORY);
        CheatSheetCollectionElement subCat = this.findChildCategory(testCat, "org.eclipse.ua.tests.subcategory");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)subCat);
    }

    @Test
    public void testFindCsInUnqualifiedSubcategory() {
        CheatSheetCollectionElement cheatSheets = CheatSheetRegistryReader.getInstance().getCheatSheets();
        CheatSheetCollectionElement testCat = this.findChildCategory(cheatSheets, TEST_CATEGORY);
        CheatSheetCollectionElement subCat = this.findChildCategory(testCat, "org.eclipse.ua.tests.subcategory");
        CheatSheetElement unqual = this.findCheatsheet(subCat, "org.eclipse.ua.tests.cheatsheet.subcategory.simple");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)unqual);
    }

    @Test
    public void testFindCsInQualifiedSubcategory() {
        CheatSheetCollectionElement cheatSheets = CheatSheetRegistryReader.getInstance().getCheatSheets();
        CheatSheetCollectionElement testCat = this.findChildCategory(cheatSheets, TEST_CATEGORY);
        CheatSheetCollectionElement subCat = this.findChildCategory(testCat, "org.eclipse.ua.tests.subcategory");
        CheatSheetElement qual = this.findCheatsheet(subCat, "org.eclipse.ua.tests.cheatsheet.subcategory.qualified");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)qual);
    }

    private CheatSheetCollectionElement findChildCategory(CheatSheetCollectionElement collection, String id) {
        Object[] subCategories;
        Object[] objectArray = subCategories = collection.getChildren();
        int n = subCategories.length;
        int n2 = 0;
        while (n2 < n) {
            Object subCategorie = objectArray[n2];
            CheatSheetCollectionElement child = (CheatSheetCollectionElement)subCategorie;
            if (child.getId().equals(id)) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    private CheatSheetElement findCheatsheet(CheatSheetCollectionElement collection, String id) {
        Object[] cheatSheets;
        Object[] objectArray = cheatSheets = collection.getCheatSheets();
        int n = cheatSheets.length;
        int n2 = 0;
        while (n2 < n) {
            Object cheatSheet = objectArray[n2];
            CheatSheetElement child = (CheatSheetElement)cheatSheet;
            if (child.getID().equals(id)) {
                return child;
            }
            ++n2;
        }
        return null;
    }
}

