/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.other;

import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetCollectionElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestCheatSheetCollection {
    private CheatSheetCollectionElement root;
    private CheatSheetElement csA;
    private CheatSheetElement csB;
    private CheatSheetElement cs12A;
    private CheatSheetElement cs2A;
    private CheatSheetCollectionElement c1;
    private CheatSheetCollectionElement c2;
    private CheatSheetCollectionElement c11;
    private CheatSheetCollectionElement c12;

    @BeforeEach
    public void setUp() throws Exception {
        this.root = new CheatSheetCollectionElement("rootPlugin", "rootId", "rootName", this.root);
        this.csA = new CheatSheetElement("A");
        this.csA.setID("idA");
        this.csB = new CheatSheetElement("B");
        this.csB.setID("idB");
        this.cs12A = new CheatSheetElement("12A");
        this.cs12A.setID("id12A");
        this.cs2A = new CheatSheetElement("2A");
        this.cs2A.setID("id2A");
        this.c1 = new CheatSheetCollectionElement("p1", "c1Id", "c1", this.root);
        this.c2 = new CheatSheetCollectionElement("p2", "c2Id", "c2", this.root);
        this.c11 = new CheatSheetCollectionElement("p11", "c11Id", "c11", this.c1);
        this.c12 = new CheatSheetCollectionElement("p12", "c12Id", "c12", this.c1);
        this.root.add(this.c1);
        this.root.add((IAdaptable)this.csA);
        this.root.add((IAdaptable)this.csB);
        this.root.add(this.c2);
        this.c1.add(this.c11);
        this.c1.add(this.c12);
        this.c2.add((IAdaptable)this.cs2A);
        this.c12.add((IAdaptable)this.cs12A);
    }

    @Test
    public void testRoot() {
        Assertions.assertThat((Object[])this.root.getChildren()).hasSize(2);
        Assertions.assertThat((Object[])this.root.getCheatSheets()).hasSize(2);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.root.isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"rootName", (Object)this.root.getLabel(null));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"rootId", (Object)this.root.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"rootPlugin", (Object)this.root.getPluginId());
    }

    @Test
    public void testTopLevelChildCategories() {
        Object[] children = this.root.getChildren();
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.c1, (Object)children[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.c2, (Object)children[1]);
        Assertions.assertThat((Object[])this.c1.getChildren()).hasSize(2);
        Assertions.assertThat((Object[])this.c1.getCheatSheets()).isEmpty();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.c1.isEmpty());
        Assertions.assertThat((Object[])this.c2.getChildren()).isEmpty();
        Assertions.assertThat((Object[])this.c2.getCheatSheets()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.c2.isEmpty());
    }

    @Test
    public void testTopLevelCheatsheets() {
        Object[] cheatsheets = this.root.getCheatSheets();
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.csA, (Object)cheatsheets[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.csB, (Object)cheatsheets[1]);
    }

    @Test
    public void testSecondLevelChildCategories() {
        Object[] children = this.c1.getChildren();
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.c11, (Object)children[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.c12, (Object)children[1]);
        Assertions.assertThat((Object[])this.c11.getChildren()).isEmpty();
        Assertions.assertThat((Object[])this.c11.getCheatSheets()).isEmpty();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.c11.isEmpty());
        Assertions.assertThat((Object[])this.c12.getChildren()).isEmpty();
        Assertions.assertThat((Object[])this.c12.getCheatSheets()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.c12.isEmpty());
    }

    @Test
    public void testFind() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.csA, (Object)this.root.findCheatSheet("idA", true));
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.csA, (Object)this.root.findCheatSheet("idA", false));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.root.findCheatSheet("idC", true));
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.cs12A, (Object)this.root.findCheatSheet("id12A", true));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.root.findCheatSheet("id12A", false));
    }
}

