/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.other;

import java.util.Set;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCheatSheetManager {
    private static final String CHEATSHEET_ID = "RandomId0234";
    private static final String CHEATSHEET_NAME = "Name";
    private static final String KEY1 = "key1";
    private static final String PARENT_KEY1 = "parent.key1";
    private static final String PARENT_KEY2 = "parent.key2";
    private static final String VALUE_A = "A";
    private static final String VALUE_B = "B";
    private static final String VALUE_C = "C";

    public CheatSheetManager createManager() {
        CheatSheetElement element = new CheatSheetElement(CHEATSHEET_NAME);
        element.setID(CHEATSHEET_ID);
        return new CheatSheetManager(element);
    }

    @Test
    public void testNewManager() {
        CheatSheetManager manager = this.createManager();
        Assertions.assertNotNull((Object)manager.getKeySet());
        Assertions.assertTrue((boolean)manager.getKeySet().isEmpty());
        Assertions.assertEquals((Object)CHEATSHEET_ID, (Object)manager.getCheatSheetID());
    }

    @Test
    public void testNoParent() {
        CheatSheetManager manager = this.createManager();
        manager.setDataQualified(KEY1, VALUE_A);
        manager.setDataQualified(PARENT_KEY1, VALUE_B);
        Assertions.assertEquals((Object)VALUE_A, (Object)manager.getData(KEY1));
        Assertions.assertEquals((Object)VALUE_A, (Object)manager.getDataQualified(KEY1));
        Assertions.assertEquals((Object)VALUE_B, (Object)manager.getData(PARENT_KEY1));
        Assertions.assertEquals((Object)VALUE_B, (Object)manager.getDataQualified(PARENT_KEY1));
        Set keys = manager.getKeySet();
        Assertions.assertEquals((int)keys.size(), (int)2);
        Assertions.assertTrue((boolean)keys.contains(KEY1));
        Assertions.assertTrue((boolean)keys.contains(PARENT_KEY1));
    }

    @Test
    public void testParentAccess() {
        CheatSheetManager manager = this.createManager();
        CheatSheetManager parentManager = this.createManager();
        manager.setParent((ICheatSheetManager)parentManager);
        manager.setDataQualified(KEY1, VALUE_A);
        manager.setDataQualified(PARENT_KEY1, VALUE_B);
        Assertions.assertEquals((Object)VALUE_A, (Object)manager.getData(KEY1));
        Assertions.assertEquals((Object)VALUE_A, (Object)manager.getDataQualified(KEY1));
        Assertions.assertNull((Object)manager.getData(PARENT_KEY1));
        Assertions.assertEquals((Object)VALUE_B, (Object)manager.getDataQualified(PARENT_KEY1));
        Set keys = manager.getKeySet();
        Assertions.assertEquals((int)keys.size(), (int)1);
        Assertions.assertTrue((boolean)keys.contains(KEY1));
        Assertions.assertFalse((boolean)keys.contains(PARENT_KEY1));
        Set parentKeys = parentManager.getKeySet();
        Assertions.assertEquals((int)parentKeys.size(), (int)1);
        Assertions.assertTrue((boolean)parentKeys.contains(KEY1));
        Assertions.assertFalse((boolean)parentKeys.contains(PARENT_KEY1));
    }

    @Test
    public void testSetDataWithParent() {
        CheatSheetManager manager = this.createManager();
        CheatSheetManager parentManager = this.createManager();
        manager.setParent((ICheatSheetManager)parentManager);
        manager.setData(KEY1, VALUE_A);
        manager.setData(PARENT_KEY1, VALUE_B);
        Assertions.assertEquals((Object)VALUE_A, (Object)manager.getData(KEY1));
        Assertions.assertEquals((Object)VALUE_A, (Object)manager.getDataQualified(KEY1));
        Assertions.assertNull((Object)manager.getDataQualified(PARENT_KEY1));
        Assertions.assertEquals((Object)VALUE_B, (Object)manager.getData(PARENT_KEY1));
        Set keys = manager.getKeySet();
        Assertions.assertEquals((int)keys.size(), (int)2);
        Assertions.assertTrue((boolean)keys.contains(KEY1));
        Assertions.assertTrue((boolean)keys.contains(PARENT_KEY1));
        Set parentKeys = parentManager.getKeySet();
        Assertions.assertEquals((int)parentKeys.size(), (int)0);
    }

    @Test
    public void testSubstitution() {
        CheatSheetManager manager = this.createManager();
        CheatSheetManager parentManager = this.createManager();
        manager.setParent((ICheatSheetManager)parentManager);
        manager.setDataQualified(KEY1, VALUE_A);
        manager.setDataQualified(PARENT_KEY1, VALUE_B);
        manager.setDataQualified(PARENT_KEY2, VALUE_C);
        Assertions.assertEquals((Object)VALUE_A, (Object)manager.getVariableData("${key1}"));
        Assertions.assertEquals((Object)VALUE_B, (Object)manager.getVariableData("${parent.key1}"));
        Assertions.assertEquals((Object)VALUE_C, (Object)manager.getVariableData("${parent.key2}"));
        Assertions.assertEquals((Object)"Values are A B C", (Object)manager.performVariableSubstitution("Values are ${key1} ${parent.key1} ${parent.key2}"));
    }
}

