/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.other;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetSaveHelper;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestStatePersistence {
    private static final String VALUE2 = "value2";
    private static final String KEY2 = "key2";
    private static final String VALUE1 = "value1";
    private static final String KEY1 = "key1";
    private static final String TEST_ID = "TestId";
    private static final String PATH = "ContentPath";
    private PropertySet propsToSave;
    private final CheatSheetSaveHelper helper = new CheatSheetSaveHelper();
    private PropertySet restored;

    @BeforeEach
    public void setUp() throws Exception {
        this.propsToSave = new PropertySet();
        this.propsToSave.button = 1;
        this.propsToSave.currentItem = 2;
        this.propsToSave.id = TEST_ID;
        this.propsToSave.contentPath = PATH;
        this.propsToSave.completed = new ArrayList<String>();
        this.propsToSave.expanded = new ArrayList<String>();
        this.propsToSave.expandRestore = new ArrayList<String>();
        this.propsToSave.subItemCompleted = new Hashtable();
        this.propsToSave.subItemSkipped = new Hashtable();
        CheatSheetElement csElement = new CheatSheetElement(TEST_ID);
        this.propsToSave.manager = new CheatSheetManager(csElement);
    }

    private void save() {
        Properties propertiesToSave = new Properties();
        propertiesToSave.put("id", this.propsToSave.id);
        propertiesToSave.put("current", Integer.toString(this.propsToSave.currentItem));
        propertiesToSave.put("button", Integer.toString(this.propsToSave.button));
        propertiesToSave.put("completed", this.propsToSave.completed);
        propertiesToSave.put("expanded", this.propsToSave.expanded);
        propertiesToSave.put("expandRestore", this.propsToSave.expandRestore);
        if (this.propsToSave.contentPath != null) {
            propertiesToSave.put("contentURL", this.propsToSave.contentPath);
        }
        if (this.propsToSave.subItemCompleted.size() > 0) {
            propertiesToSave.put("subitemcompleted", this.propsToSave.subItemCompleted);
        }
        if (this.propsToSave.subItemSkipped.size() > 0) {
            propertiesToSave.put("subitemskipped", this.propsToSave.subItemSkipped);
        }
        this.helper.saveState(propertiesToSave, this.propsToSave.manager);
    }

    private PropertySet restore(String id) {
        PropertySet result = new PropertySet();
        Properties restored = this.helper.loadState(id);
        result.id = restored.getProperty("id");
        result.button = Integer.parseInt(restored.getProperty("button"));
        result.currentItem = Integer.parseInt(restored.getProperty("current"));
        result.completed = (ArrayList)restored.get("completed");
        result.contentPath = (String)restored.get("contentURL");
        result.expanded = (ArrayList)restored.get("expanded");
        result.expandRestore = (ArrayList)restored.get("expandRestore");
        result.subItemCompleted = (Hashtable)restored.get("subitemcompleted");
        result.subItemSkipped = (Hashtable)restored.get("subitemskipped");
        Hashtable managerData = (Hashtable)restored.get("CSMData");
        CheatSheetElement csElement = new CheatSheetElement(id);
        result.manager = new CheatSheetManager(csElement);
        result.manager.setData((Map)managerData);
        return result;
    }

    private void restore() {
        this.restored = this.restore(TEST_ID);
    }

    @Test
    public void testBasicProperties() {
        this.save();
        this.restore();
        Assertions.assertEquals((Object)TEST_ID, (Object)this.restored.id);
        Assertions.assertEquals((int)2, (int)this.restored.currentItem);
        Assertions.assertEquals((int)1, (int)this.restored.button);
        Assertions.assertEquals((Object)PATH, (Object)this.restored.contentPath);
    }

    @Test
    public void testCheatSheetManagerPersistence() {
        this.propsToSave.manager.setData(KEY1, VALUE1);
        this.propsToSave.manager.setData(KEY2, VALUE2);
        this.save();
        this.restore();
        Assertions.assertEquals((Object)VALUE1, (Object)this.restored.manager.getData(KEY1));
        Assertions.assertEquals((Object)VALUE2, (Object)this.restored.manager.getData(KEY2));
    }

    @Test
    public void testItemPropertyPersistence() {
        this.propsToSave.completed.add("2");
        this.propsToSave.completed.add("5");
        this.propsToSave.expanded.add("3");
        this.propsToSave.expanded.add("6");
        this.propsToSave.expandRestore.add("9");
        this.propsToSave.expandRestore.add("99");
        this.propsToSave.expandRestore.add("999");
        this.save();
        this.restore();
        Assertions.assertEquals((int)2, (int)this.restored.completed.size());
        Assertions.assertTrue((boolean)this.restored.completed.contains("2"));
        Assertions.assertTrue((boolean)this.restored.completed.contains("5"));
        Assertions.assertFalse((boolean)this.restored.completed.contains("3"));
        Assertions.assertEquals((int)2, (int)this.restored.expanded.size());
        Assertions.assertTrue((boolean)this.restored.expanded.contains("3"));
        Assertions.assertTrue((boolean)this.restored.expanded.contains("6"));
        Assertions.assertEquals((int)3, (int)this.restored.expandRestore.size());
        Assertions.assertTrue((boolean)this.restored.expandRestore.contains("9"));
        Assertions.assertTrue((boolean)this.restored.expandRestore.contains("99"));
        Assertions.assertTrue((boolean)this.restored.expandRestore.contains("999"));
    }

    @Test
    public void testSubItemPropertyPersistence() {
        this.propsToSave.subItemCompleted.put("1", "3,5");
        this.propsToSave.subItemCompleted.put("2", "4,6");
        this.propsToSave.subItemSkipped.put("3", "1,4,9");
        this.save();
        this.restore();
        Assertions.assertEquals((int)2, (int)this.restored.subItemCompleted.size());
        Assertions.assertEquals((Object)"3,5", (Object)this.restored.subItemCompleted.get("1"));
        Assertions.assertEquals((Object)"4,6", (Object)this.restored.subItemCompleted.get("2"));
        Assertions.assertEquals((int)1, (int)this.restored.subItemSkipped.size());
        Assertions.assertEquals((Object)"1,4,9", (Object)this.restored.subItemSkipped.get("3"));
    }

    private static class PropertySet {
        public String id;
        public int currentItem;
        public int button;
        public String contentPath;
        public List<String> completed;
        public List<String> expanded;
        public List<String> expandRestore;
        public Hashtable<String, String> subItemCompleted;
        public Hashtable<String, String> subItemSkipped;
        public CheatSheetManager manager;

        private PropertySet() {
        }
    }
}

