/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.parser;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.ua.tests.cheatsheet.util.StatusCheck;
import org.eclipse.ua.tests.util.ResourceFinder;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetParser;
import org.eclipse.ui.internal.cheatsheets.data.ICheatSheet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.FrameworkUtil;

public class InvalidCheatsheet {
    private static final String INVALID_CHEATSHEET_FOLDER = "data/cheatsheet/invalid/";
    private CheatSheetParser parser;
    private String bundleSymbolicName;

    @BeforeEach
    public void setUp() throws Exception {
        this.parser = new CheatSheetParser();
        this.bundleSymbolicName = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
    }

    private ICheatSheet parseTestFile(String path) {
        URL testURL = ResourceFinder.findFile(FrameworkUtil.getBundle(InvalidCheatsheet.class), INVALID_CHEATSHEET_FOLDER + path);
        return this.parser.parse(testURL, this.bundleSymbolicName, 2);
    }

    @Test
    public void testBadURL() {
        try {
            Assertions.assertNull((Object)this.parser.parse(new URL("file:/nonexistent"), this.bundleSymbolicName, 2));
        }
        catch (MalformedURLException e) {
            Assertions.fail((String)"Exception thrown");
        }
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "Could not open");
    }

    @Test
    public void testActionMissingClass() {
        ICheatSheet model = this.parseTestFile("ActionElement_MissingClass.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "must specify a class");
    }

    @Test
    public void testActionMissingPluginId() {
        ICheatSheet model = this.parseTestFile("ActionElement_MissingPluginId.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "must specify a pluginId");
    }

    @Test
    public void testCommandMissingSerialization() {
        ICheatSheet model = this.parseTestFile("Command_MissingSerialization.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "must specify a serialization");
    }

    @Test
    public void testInvalidParamNumber() {
        ICheatSheet model = this.parseTestFile("ActionElement_ParamInvalidNumber.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "invalid parameter number");
    }

    @Test
    public void testInvalidParamRange() {
        ICheatSheet model = this.parseTestFile("ActionElement_ParamInvalidRange.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "invalid range");
    }

    @Test
    public void testMissingTitle() {
        ICheatSheet model = this.parseTestFile("CheatSheetElement_MissingTitle.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "must specify a title");
    }

    @Test
    public void testNotDefined() {
        ICheatSheet model = this.parseTestFile("CheatSheetElement_NotDefined.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "The <cheatsheet> element must be the root");
    }

    @Test
    public void testConditionalSubitemMissingCondition() {
        ICheatSheet model = this.parseTestFile("CondSubItem_MissingCondition.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "must specify a condition");
    }

    @Test
    public void testConditionalSubitemMissingSubitem() {
        ICheatSheet model = this.parseTestFile("CondSubItem_MissingSubItem.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "must specify a subitem");
    }

    @Test
    public void testIntroElementManyDefined() {
        ICheatSheet model = this.parseTestFile("IntroElement_ManyDefined.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "can only contain one <intro> element");
    }

    @Test
    public void testIntroElementMissingDescription() {
        ICheatSheet model = this.parseTestFile("IntroElement_MissingDescription.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "The description for element 'intro' was not defined");
    }

    @Test
    public void testIntroElementManyDescriptions() {
        ICheatSheet model = this.parseTestFile("IntroElement_ManyDescriptions.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "more than one description");
    }

    @Test
    public void testIntroElementNotDefined() {
        ICheatSheet model = this.parseTestFile("IntroElement_NotDefined.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "must contain an <intro>");
    }

    @Test
    public void testItemElementMissingTitle() {
        ICheatSheet model = this.parseTestFile("ItemElement_MissingTitle.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "must specify a title");
    }

    @Test
    public void testItemElementMissingDescription() {
        ICheatSheet model = this.parseTestFile("ItemElement_MissingDescription.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "The description for element 'item' was not defined");
    }

    @Test
    public void testItemElementManyDescriptions() {
        ICheatSheet model = this.parseTestFile("ItemElement_ManyDescriptions.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "more than one description");
    }

    @Test
    public void testItemElementNotDefined() {
        ICheatSheet model = this.parseTestFile("ItemElement_NotDefined.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "at least one <item>");
    }

    @Test
    public void testPerformWhenMissingAction() {
        ICheatSheet model = this.parseTestFile("PerformWhen_MissingAction.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "must specify an action");
    }

    @Test
    public void testPerformWhenMissingCondition() {
        ICheatSheet model = this.parseTestFile("PerformWhen_MissingCondition.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "must specify a condition");
    }

    @Test
    public void testSubitemElementMissingLabel() {
        ICheatSheet model = this.parseTestFile("SubItem_MissingLabel.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "must specify a label");
    }

    @Test
    public void testRepeatedSubitemMissingSubitem() {
        ICheatSheet model = this.parseTestFile("RepSubItem_MissingSubItem.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "must specify a subitem");
    }

    @Test
    public void testRepeatedSubitemMissingValues() {
        ICheatSheet model = this.parseTestFile("RepSubItem_MissingValues.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "must specify a values");
    }

    @Test
    public void testActionAndPerformWhen() {
        ICheatSheet model = this.parseTestFile("ActionAndPerformWhen.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "incompatible");
    }

    @Test
    public void testCommandAndAction() {
        ICheatSheet model = this.parseTestFile("CommandAndAction.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "incompatible");
    }

    @Test
    public void testCommandAndSubitem() {
        ICheatSheet model = this.parseTestFile("CommandAndSubitem.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "incompatible");
    }

    @Test
    public void testSubitemAndPerformWhen() {
        ICheatSheet model = this.parseTestFile("SubitemAndPerformWhen.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "incompatible");
    }

    @Test
    public void testTwoActions() {
        ICheatSheet model = this.parseTestFile("TwoActions.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "more than one");
    }

    @Test
    public void testTwoCommands() {
        ICheatSheet model = this.parseTestFile("TwoCommands.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "more than one");
    }

    @Test
    public void testTwoPerformWhen() {
        ICheatSheet model = this.parseTestFile("TwoPerformWhen.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "more than one");
    }

    @Test
    public void testConfirmTrueRequiredFalse() {
        ICheatSheet model = this.parseTestFile("ConfirmTrueRequiredFalse.xml");
        Assertions.assertNull((Object)model);
        Assertions.assertEquals((int)4, (int)this.parser.getStatus().getSeverity());
        StatusCheck.assertStatusContains(this.parser.getStatus(), "required = false and confirm = true");
    }
}

