/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.parser;

import java.net.URL;
import org.eclipse.ua.tests.util.ResourceFinder;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheet;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetParser;
import org.eclipse.ui.internal.cheatsheets.data.ICheatSheet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.FrameworkUtil;

public class NoError {
    private static final String NO_ERROR_FOLDER = "data/cheatsheet/no_error/";
    private static final String OTHER_FOLDER = "data/cheatsheet/other/";
    private CheatSheetParser parser;

    @BeforeEach
    public void setUp() throws Exception {
        this.parser = new CheatSheetParser();
    }

    private ICheatSheet parseTestFile(String path) {
        URL testURL = ResourceFinder.findFile(FrameworkUtil.getBundle(NoError.class), path);
        return this.parser.parse(testURL, FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), 2);
    }

    @Test
    public void testConfirmRequiredCombinations() {
        ICheatSheet model = this.parseTestFile("data/cheatsheet/no_error/ConfirmRequired.xml");
        Assertions.assertNotNull((Object)model);
        Assertions.assertTrue((boolean)this.parser.getStatus().isOK());
    }

    @Test
    public void testRestrictedAction() {
        ICheatSheet model = this.parseTestFile("data/cheatsheet/other/TestActions.xml");
        Assertions.assertNotNull((Object)model);
        Assertions.assertTrue((boolean)this.parser.getStatus().isOK());
        Assertions.assertTrue((boolean)(model instanceof CheatSheet));
        Assertions.assertTrue((boolean)((CheatSheet)model).isContainsCommandOrAction());
    }

    @Test
    public void testRestrictedCommand() {
        ICheatSheet model = this.parseTestFile("data/cheatsheet/other/TestCommand.xml");
        Assertions.assertNotNull((Object)model);
        Assertions.assertTrue((boolean)this.parser.getStatus().isOK());
        Assertions.assertTrue((boolean)(model instanceof CheatSheet));
        Assertions.assertTrue((boolean)((CheatSheet)model).isContainsCommandOrAction());
    }

    @Test
    public void testNoRestriction() {
        ICheatSheet model = this.parseTestFile("data/cheatsheet/other/NoActions.xml");
        Assertions.assertNotNull((Object)model);
        Assertions.assertTrue((boolean)this.parser.getStatus().isOK());
        Assertions.assertTrue((boolean)(model instanceof CheatSheet));
        Assertions.assertFalse((boolean)((CheatSheet)model).isContainsCommandOrAction());
    }
}

