/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.parser;

import java.net.URL;
import org.eclipse.ua.tests.util.ResourceFinder;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetParser;
import org.eclipse.ui.internal.cheatsheets.data.ICheatSheet;
import org.eclipse.ui.internal.cheatsheets.data.ParserInput;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.osgi.framework.FrameworkUtil;

public class ParseFromString {
    private static final String VALID_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?> <cheatsheet title=\"Title\"><intro><description>Simple test</description></intro><item title=\"Item\"><description>description</description></item></cheatsheet>";
    private static final String INVALID_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?> <cheatsheet title=\"Title\"><intro><description>Simple test</description></intro></cheatsheet>";

    @Test
    public void testElementXml() {
        CheatSheetElement element = new CheatSheetElement("name");
        Assertions.assertNull((Object)element.getContentXml());
        element.setContentXml(VALID_CONTENT);
    }

    @Test
    public void testDefaultParserInput() {
        ParserInput input = new ParserInput();
        Assertions.assertNull((Object)input.getUrl());
        Assertions.assertNull((Object)input.getXml());
    }

    @Test
    public void testXmlParserInput() {
        ParserInput input = new ParserInput(VALID_CONTENT, null);
        Assertions.assertNull((Object)input.getUrl());
        Assertions.assertEquals((Object)VALID_CONTENT, (Object)input.getXml());
    }

    @Test
    public void testUrlParserInput() {
        URL testURL = ResourceFinder.findFile(FrameworkUtil.getBundle(ParseFromString.class), "data/cheatsheet/valid/HelloWorld.xml");
        ParserInput input = new ParserInput(testURL, FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), null);
        Assertions.assertNull((Object)input.getXml());
        Assertions.assertTrue((boolean)testURL.equals(input.getUrl()));
    }

    @Test
    public void testValidCheatsheet() {
        ParserInput input = new ParserInput(VALID_CONTENT, null);
        CheatSheetParser parser = new CheatSheetParser();
        ICheatSheet cheatSheet = parser.parse(input, 2);
        Assertions.assertNotNull((Object)cheatSheet);
        Assertions.assertEquals((int)0, (int)parser.getStatus().getSeverity());
    }

    @Test
    public void testInvalidCheatsheet() {
        ParserInput input = new ParserInput(INVALID_CONTENT, null);
        CheatSheetParser parser = new CheatSheetParser();
        ICheatSheet cheatSheet = parser.parse(input, 2);
        Assertions.assertNull((Object)cheatSheet);
        Assertions.assertEquals((int)4, (int)parser.getStatus().getSeverity());
        Assertions.assertTrue((boolean)parser.getStatus().getMessage().contains("must contain at least one <item>"));
    }
}

