/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.parser;

import java.net.URL;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetParser;
import org.eclipse.ui.internal.cheatsheets.data.ICheatSheet;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TolerateTest {
    private void parseCheatsheet(String file) {
        IPath path = IPath.fromOSString((String)("data/cheatsheet/valid/tolerate/" + file));
        URL url = FileLocator.find((Bundle)FrameworkUtil.getBundle(TolerateTest.class), (IPath)path, null);
        CheatSheetParser parser = new CheatSheetParser();
        ICheatSheet sheet = parser.parse(url, FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), 2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)parser.getStatus().getSeverity()).as("warning not generated: " + String.valueOf(url), new Object[0])).isEqualTo(2);
        ((ObjectAssert)Assertions.assertThat((Object)sheet).withFailMessage("tried parsing a tolerable cheat sheet but parser returned null: " + String.valueOf(url), new Object[0])).isNotNull();
    }

    @Test
    public void testItemExtraAttr() {
        this.parseCheatsheet("ItemElement_ExtraAttr.xml");
    }

    @Test
    public void testIntroExtraElement() {
        this.parseCheatsheet("IntroElement_ExtraElement.xml");
    }

    @Test
    public void testIntroExtraAttr() {
        this.parseCheatsheet("IntroElement_ExtraAttr.xml");
    }

    @Test
    public void testDescExtraElement() {
        this.parseCheatsheet("DescriptionElement_ExtraElements.xml");
    }

    @Test
    public void testConditionalExtraElement() {
        this.parseCheatsheet("ConditionalSubItem_ExtraElement.xml");
    }

    @Test
    public void testConditionalExtraAttr() {
        this.parseCheatsheet("ConditionalSubItem_ExtraAttr.xml");
    }

    @Test
    public void testElementExtraElement() {
        this.parseCheatsheet("CheatSheetElement_ExtraElement.xml");
    }

    @Test
    public void testElementExtraAttr() {
        this.parseCheatsheet("CheatSheetElement_ExtraAttr.xml");
    }

    @Test
    public void testExtraElement() {
        this.parseCheatsheet("ActionElement_ExtraElement.xml");
    }

    @Test
    public void testExtraAttr() {
        this.parseCheatsheet("ActionElement_ExtraAttr.xml");
    }
}

