/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.parser;

import java.io.IOException;
import java.net.URL;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ua.tests.cheatsheet.util.CheatSheetModelSerializer;
import org.eclipse.ua.tests.util.FileUtil;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheet;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetParser;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ValidTest {
    private void parseCheatsheet(String file) throws IOException {
        IPath path = IPath.fromOSString((String)("data/cheatsheet/valid/" + file));
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        CheatSheetParser parser = new CheatSheetParser();
        CheatSheet sheet = (CheatSheet)parser.parse(url, bundle.getSymbolicName(), 3);
        ((ObjectAssert)Assertions.assertThat((Object)sheet).as("tried parsing a valid cheat sheet but parser returned null: " + String.valueOf(url), new Object[0])).isNotNull();
        String expectedPath = "data/cheatsheet/valid/" + this.getExpected(file);
        String expected = FileUtil.getContents(bundle, expectedPath);
        String actual = CheatSheetModelSerializer.serialize(sheet);
        ((AbstractStringAssert)Assertions.assertThat((String)actual).as("the model serialization generated for the cheatsheet did not match the expected result for: " + String.valueOf(path), new Object[0])).isEqualTo(expected);
    }

    private String getExpected(String file) {
        int suffix = file.lastIndexOf(".xml");
        return file.substring(0, suffix) + "_expected.txt";
    }

    @Test
    public void testSubItems() throws IOException {
        this.parseCheatsheet("TestSubItems.xml");
    }

    @Test
    public void testParameters() throws IOException {
        this.parseCheatsheet("TestParameters.xml");
    }

    @Test
    public void testOpeningURL() throws IOException {
        this.parseCheatsheet("TestOpeningURL.xml");
    }

    @Test
    public void testDynamicSubitems() throws IOException {
        this.parseCheatsheet("TestDynamicSubItems.xml");
    }

    @Test
    public void testDescriptionFormatting() throws IOException {
        this.parseCheatsheet("TestDescriptionFormatting.xml");
    }

    @Test
    public void testCSActions() throws IOException {
        this.parseCheatsheet("TestCSActions.xml");
    }

    @Test
    public void testContextHelp() throws IOException {
        this.parseCheatsheet("TestContext_Help.xml");
    }

    @Test
    public void testActions() throws IOException {
        this.parseCheatsheet("TestActions.xml");
    }

    @Test
    public void testHelloWorldWithSubitems() throws IOException {
        this.parseCheatsheet("HelloWorldWithSubitems.xml");
    }

    @Test
    public void testHelloWorldWithExtensions() throws IOException {
        this.parseCheatsheet("HelloWorldWithExtensions.xml");
    }

    @Test
    public void testHelloWorld() throws IOException {
        this.parseCheatsheet("HelloWorld.xml");
    }

    @Test
    public void testHyperlinks() throws IOException {
        this.parseCheatsheet("TestCSHyperlinks.xml");
    }
}

