/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.performance;

import org.eclipse.swt.widgets.Display;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceTestCaseJunit5;
import org.eclipse.ua.tests.intro.performance.OpenIntroTest;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class OpenCheatSheetTest
extends PerformanceTestCaseJunit5 {
    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        super.setUp(testInfo);
        OpenIntroTest.closeIntro();
    }

    @Test
    public void testOpenSimpleCheatSheet() throws Exception {
        this.tagAsSummary("Open simple cheat sheet", Dimension.ELAPSED_PROCESS);
        int i = 0;
        while (i < 3) {
            this.closeCheatSheet();
            this.openSimpleCheatSheet();
            ++i;
        }
        i = 0;
        while (i < 50) {
            this.closeCheatSheet();
            this.startMeasuring();
            this.openSimpleCheatSheet();
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    @Test
    public void testOpenCompositeCheatSheet() throws Exception {
        this.tagAsSummary("Open composite cheat sheet", Dimension.ELAPSED_PROCESS);
        int i = 0;
        while (i < 3) {
            this.closeCheatSheet();
            this.openCompositeCheatSheet();
            ++i;
        }
        i = 0;
        while (i < 50) {
            this.closeCheatSheet();
            this.startMeasuring();
            this.openCompositeCheatSheet();
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    private void openSimpleCheatSheet() throws Exception {
        OpenCheatSheetAction action = new OpenCheatSheetAction("org.eclipse.ua.tests.cheatsheet.performance.simple");
        action.run();
        OpenCheatSheetTest.flush();
    }

    private void openCompositeCheatSheet() throws Exception {
        OpenCheatSheetAction action = new OpenCheatSheetAction("org.eclipse.ua.tests.cheatsheet.performance.composite");
        action.run();
        OpenCheatSheetTest.flush();
    }

    private void closeCheatSheet() throws Exception {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart view = page.findView("org.eclipse.ui.cheatsheets.views.CheatSheetView");
        page.hideView(view);
        OpenCheatSheetTest.flush();
    }

    private static void flush() {
        Display display = Display.getCurrent();
        while (display.readAndDispatch()) {
        }
    }
}

