/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.cheatsheet.util;

import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.ui.cheatsheets.AbstractItemExtensionElement;
import org.eclipse.ui.internal.cheatsheets.data.AbstractSubItem;
import org.eclipse.ui.internal.cheatsheets.data.Action;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheet;
import org.eclipse.ui.internal.cheatsheets.data.ConditionalSubItem;
import org.eclipse.ui.internal.cheatsheets.data.Item;
import org.eclipse.ui.internal.cheatsheets.data.PerformWhen;
import org.eclipse.ui.internal.cheatsheets.data.RepeatedSubItem;
import org.eclipse.ui.internal.cheatsheets.data.SubItem;

public class CheatSheetModelSerializer {
    public static String serialize(CheatSheet sheet) {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        if (sheet == null) {
            buf.append("<nullCheatSheet/>\n");
        } else {
            buf.append("<cheatsheet\n");
            buf.append("      title=\"" + sheet.getTitle() + "\">\n");
            buf.append(CheatSheetModelSerializer.serialize(sheet.getIntroItem(), "   "));
            buf.append(CheatSheetModelSerializer.serialize(sheet.getItems(), "   "));
            buf.append("</cheatsheet>");
        }
        return buf.toString();
    }

    public static String serialize(Item item, String indent) {
        StringBuilder buf = new StringBuilder();
        if (item == null) {
            buf.append(indent + "<nullItem/>\n");
        } else {
            buf.append(indent + "<item\n");
            buf.append(indent + "      title=\"" + item.getTitle() + "\"\n");
            buf.append(indent + "      description=\"" + item.getDescription() + "\"\n");
            buf.append(indent + "      Href=\"" + item.getHref() + "\"\n");
            buf.append(indent + "      contextId=\"" + item.getContextId() + "\">\n");
            buf.append(CheatSheetModelSerializer.serialize((Action)item.getExecutable(), indent + "   "));
            buf.append(CheatSheetModelSerializer.serialize(item.getItemExtensions(), indent + "   "));
            buf.append(CheatSheetModelSerializer.serialize(item.getPerformWhen(), indent + "   "));
            buf.append(CheatSheetModelSerializer.serialize(item.getSubItems(), indent + "   "));
            buf.append(indent + "</item>\n");
        }
        return buf.toString();
    }

    public static String serialize(Action action, String indent) {
        StringBuilder buf = new StringBuilder();
        if (action == null) {
            buf.append(indent + "<nullAction/>\n");
        } else {
            buf.append(indent + "<action\n");
            buf.append(indent + "      class=\"" + action.getActionClass() + "\"\n");
            buf.append(indent + "      pluginId=\"" + action.getPluginID() + "\"\n");
            buf.append(indent + "      when=\"" + action.getWhen() + "\"\n");
            buf.append(indent + "      isConfirm=\"" + action.isConfirm() + "\">\n");
            buf.append(CheatSheetModelSerializer.serialize(action.getParams(), indent + "   "));
            buf.append(indent + "</action>\n");
        }
        return buf.toString();
    }

    public static String serialize(String string, String indent) {
        StringBuilder buf = new StringBuilder();
        if (string == null) {
            buf.append(indent + "<nullString/>\n");
        } else {
            buf.append(indent + "<string\n");
            buf.append(indent + "      value=\"" + string + "\">\n");
            buf.append(indent + "</string>\n");
        }
        return buf.toString();
    }

    public static String serialize(AbstractItemExtensionElement ext, String indent) {
        StringBuilder buf = new StringBuilder();
        buf.append(indent + "<itemExtension\n");
        buf.append(indent + "      attributeName=\"" + ext.getAttributeName() + "\">\n");
        buf.append(indent + "</itemExtension>\n");
        return buf.toString();
    }

    public static String serialize(PerformWhen performWhen, String indent) {
        StringBuilder buf = new StringBuilder();
        if (performWhen == null) {
            buf.append(indent + "<nullPerformWhen/>\n");
        } else {
            buf.append(indent + "<performWhen\n");
            buf.append(indent + "      condition=\"" + performWhen.getCondition() + "\">\n");
            buf.append(CheatSheetModelSerializer.serialize(performWhen.getExecutables(), indent + "   "));
            buf.append(indent + "</performWhen>\n");
        }
        return buf.toString();
    }

    public static String serialize(AbstractSubItem subItem, String indent) {
        StringBuilder buf = new StringBuilder();
        if (subItem == null) {
            buf.append(indent + "<nullSubItem/>\n");
        } else if (subItem instanceof ConditionalSubItem) {
            ConditionalSubItem c = (ConditionalSubItem)subItem;
            buf.append(indent + "<conditionalSubItem\n");
            buf.append(indent + "      condition=\"" + c.getCondition() + "\">\n");
            buf.append(CheatSheetModelSerializer.serialize(c.getSubItems(), indent + "   "));
            buf.append(indent + "</conditionalSubItem>\n");
        } else if (subItem instanceof RepeatedSubItem) {
            RepeatedSubItem r = (RepeatedSubItem)subItem;
            buf.append(indent + "<repeatedSubItem\n");
            buf.append(indent + "      values=\"" + r.getValues() + "\">\n");
            buf.append(CheatSheetModelSerializer.serialize(r.getSubItems(), indent + "   "));
            buf.append(indent + "</repeatedSubItem>\n");
        } else if (subItem instanceof SubItem) {
            SubItem s = (SubItem)subItem;
            buf.append(indent + "<subItem\n");
            buf.append(indent + "      label=\"" + s.getLabel() + "\"\n");
            buf.append(indent + "      when=\"" + s.getWhen() + "\"\n");
            buf.append(indent + "      isSkip=\"" + s.isSkip() + "\">\n");
            buf.append(CheatSheetModelSerializer.serialize((Action)s.getExecutable(), indent + "   "));
            buf.append(CheatSheetModelSerializer.serialize(s.getPerformWhen(), indent + "   "));
            buf.append(indent + "</subItem>\n");
        } else {
            throw new IllegalArgumentException("Unknown sub item type: " + String.valueOf(subItem.getClass()));
        }
        return buf.toString();
    }

    public static String serialize(Object[] array, String indent) {
        StringBuilder buf = new StringBuilder();
        if (array == null) {
            buf.append(indent + "<nullArray/>\n");
        } else if (array.length == 0) {
            buf.append(indent + "<array/>\n");
        } else {
            buf.append(indent + "<array>\n");
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj != null) {
                    Method[] methods;
                    Class<?> c = obj.getClass();
                    boolean found = false;
                    Method[] methodArray = methods = CheatSheetModelSerializer.class.getMethods();
                    int n3 = methods.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Method method = methodArray[n4];
                        Class<?>[] params = method.getParameterTypes();
                        if (params.length == 2 && params[0].isAssignableFrom(c) && params[1].equals(String.class)) {
                            try {
                                buf.append(method.invoke(null, obj, indent + "   "));
                            }
                            catch (Exception e) {
                                buf.append(indent + "   " + String.valueOf(e) + ", cause: " + String.valueOf(e.getCause()));
                                e.printStackTrace();
                            }
                            found = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!found) {
                        System.err.println("Could not find serializer for: " + String.valueOf(c));
                    }
                } else {
                    buf.append(indent + "   <nullObject/>\n");
                }
                ++n2;
            }
            buf.append(indent + "</array>\n");
        }
        return buf.toString();
    }

    public static String serialize(List<?> list, String indent) {
        StringBuilder buf = new StringBuilder();
        if (list == null) {
            buf.append(indent + "<nullList/>\n");
        } else if (list.isEmpty()) {
            buf.append(indent + "<list/>\n");
        } else {
            buf.append(indent + "<list>\n");
            for (Object obj : list) {
                if (obj != null) {
                    Method[] methods;
                    Class<?> c = obj.getClass();
                    boolean found = false;
                    Method[] methodArray = methods = CheatSheetModelSerializer.class.getMethods();
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method method = methodArray[n2];
                        Class<?>[] params = method.getParameterTypes();
                        if (params.length == 2 && params[0].isAssignableFrom(c) && params[1].equals(String.class)) {
                            try {
                                buf.append(method.invoke(null, obj, indent + "   "));
                            }
                            catch (Exception e) {
                                buf.append(indent + "   " + String.valueOf(e) + ", cause: " + String.valueOf(e.getCause()));
                                e.printStackTrace();
                            }
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (found) continue;
                    System.err.println("Could not find serializer for: " + String.valueOf(c));
                    continue;
                }
                buf.append(indent + "   <nullObject/>\n");
            }
            buf.append(indent + "</list>\n");
        }
        return buf.toString();
    }
}

