/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.criteria;

import org.assertj.core.api.Assertions;
import org.eclipse.help.ICriterionDefinition;
import org.eclipse.help.ICriterionValueDefinition;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.UAElementFactory;
import org.eclipse.help.internal.criteria.CriterionDefinition;
import org.eclipse.help.internal.criteria.CriterionValueDefinition;
import org.eclipse.ua.tests.help.other.UserCriterionDefinition;
import org.eclipse.ua.tests.help.other.UserCriterionValueDefinition;
import org.junit.jupiter.api.Test;

public class CriteriaDefinitionTest {
    private static final String VALUEID1 = "valueid1";
    private static final String VALUENAME1 = "first value";
    private static final String VALUEID2 = "valueid2";
    private static final String VALUENAME2 = "second value";
    private static final String CRITERIONID1 = "criterionid1";
    private static final String CRITERIONNAME1 = "first criterion";

    @Test
    public void testCriterionValueDefinition() {
        UserCriterionValueDefinition valueDefinition = new UserCriterionValueDefinition(VALUEID1, VALUENAME1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)VALUEID1, (Object)valueDefinition.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)VALUENAME1, (Object)valueDefinition.getName());
        Assertions.assertThat((Object[])valueDefinition.getChildren()).isEmpty();
    }

    @Test
    public void testCopyCriterionValueDefinition() {
        UserCriterionValueDefinition valueDefinition = new UserCriterionValueDefinition(VALUEID1, VALUENAME1);
        CriterionValueDefinition copy = new CriterionValueDefinition((ICriterionValueDefinition)valueDefinition);
        org.junit.jupiter.api.Assertions.assertEquals((Object)VALUEID1, (Object)copy.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)VALUENAME1, (Object)copy.getName());
        Assertions.assertThat((Object[])copy.getChildren()).isEmpty();
    }

    @Test
    public void testFactoryCreateValueDefinition() {
        UserCriterionValueDefinition valueDefinition = new UserCriterionValueDefinition(VALUEID1, VALUENAME1);
        UAElement element = UAElementFactory.newElement((IUAElement)valueDefinition);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)element);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(element instanceof ICriterionValueDefinition));
        ICriterionValueDefinition copy = (ICriterionValueDefinition)element;
        org.junit.jupiter.api.Assertions.assertEquals((Object)VALUEID1, (Object)copy.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)VALUENAME1, (Object)copy.getName());
        Assertions.assertThat((Object[])copy.getChildren()).isEmpty();
    }

    @Test
    public void testCriterionDefinition() {
        UserCriterionDefinition definition = new UserCriterionDefinition(CRITERIONID1, CRITERIONNAME1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)CRITERIONID1, (Object)definition.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)CRITERIONNAME1, (Object)definition.getName());
        Assertions.assertThat((Object[])definition.getChildren()).isEmpty();
    }

    @Test
    public void testCopyCriterionDefinition() {
        UserCriterionDefinition definition = new UserCriterionDefinition(CRITERIONID1, CRITERIONNAME1);
        CriterionDefinition copy = new CriterionDefinition((ICriterionDefinition)definition);
        org.junit.jupiter.api.Assertions.assertEquals((Object)CRITERIONID1, (Object)copy.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)CRITERIONNAME1, (Object)copy.getName());
        Assertions.assertThat((Object[])copy.getChildren()).isEmpty();
    }

    @Test
    public void testFactoryCreateDefinition() {
        UserCriterionDefinition definition = new UserCriterionDefinition(CRITERIONID1, CRITERIONNAME1);
        UAElement element = UAElementFactory.newElement((IUAElement)definition);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)element);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(element instanceof ICriterionDefinition));
        ICriterionDefinition copy = (ICriterionDefinition)element;
        org.junit.jupiter.api.Assertions.assertEquals((Object)CRITERIONID1, (Object)copy.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)CRITERIONNAME1, (Object)copy.getName());
        Assertions.assertThat((Object[])copy.getChildren()).isEmpty();
    }

    @Test
    public void testCriterionDefinitionWithValues() {
        UserCriterionDefinition definition = this.createDefinitionWithValues();
        this.checkDefinitionWithValues(definition);
    }

    @Test
    public void testCopyCriterionDefinitionWithValues() {
        UserCriterionDefinition definition = this.createDefinitionWithValues();
        CriterionDefinition copy = new CriterionDefinition((ICriterionDefinition)definition);
        this.checkDefinitionWithValues((ICriterionDefinition)copy);
    }

    @Test
    public void testFactoryCreateCriterionDefinitionWithValues() {
        UserCriterionDefinition definition = this.createDefinitionWithValues();
        UAElement element = UAElementFactory.newElement((IUAElement)definition);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)element);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(element instanceof ICriterionDefinition));
        ICriterionDefinition copy = (ICriterionDefinition)element;
        this.checkDefinitionWithValues(copy);
    }

    private UserCriterionDefinition createDefinitionWithValues() {
        UserCriterionDefinition definition = new UserCriterionDefinition(CRITERIONID1, CRITERIONNAME1);
        UserCriterionValueDefinition valueDefinition1 = new UserCriterionValueDefinition(VALUEID1, VALUENAME1);
        UserCriterionValueDefinition valueDefinition2 = new UserCriterionValueDefinition(VALUEID2, VALUENAME2);
        definition.addValue(valueDefinition1);
        definition.addValue(valueDefinition2);
        return definition;
    }

    private void checkDefinitionWithValues(ICriterionDefinition copy) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)CRITERIONID1, (Object)copy.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)CRITERIONNAME1, (Object)copy.getName());
        Object[] values = copy.getCriterionValueDefinitions();
        Assertions.assertThat((Object[])values).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)VALUEID1, (Object)values[0].getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)VALUENAME1, (Object)values[0].getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)VALUEID2, (Object)values[1].getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)VALUENAME2, (Object)values[1].getName());
    }
}

