/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.criteria;

import java.util.List;
import org.eclipse.help.internal.base.util.CriteriaUtilities;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CriteriaUtilitiesTest {
    @Test
    public void testNullValues() {
        List values = CriteriaUtilities.getCriteriaValues(null);
        Assertions.assertEquals((int)0, (int)values.size());
    }

    @Test
    public void testSingleValue() {
        List values = CriteriaUtilities.getCriteriaValues((String)"1.0");
        Assertions.assertEquals((int)1, (int)values.size());
        Assertions.assertEquals((Object)"1.0", values.get(0));
    }

    @Test
    public void testSingleValueWithWhitespace() {
        List values = CriteriaUtilities.getCriteriaValues((String)" 1.0 ");
        Assertions.assertEquals((int)1, (int)values.size());
        Assertions.assertEquals((Object)"1.0", values.get(0));
    }

    @Test
    public void testMultipleValues() {
        List values = CriteriaUtilities.getCriteriaValues((String)" 1.0, 2.0 ");
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertEquals((Object)"1.0", values.get(0));
        Assertions.assertEquals((Object)"2.0", values.get(1));
    }

    @Test
    public void testUppercaseValue() {
        List values = CriteriaUtilities.getCriteriaValues((String)"LINUX");
        Assertions.assertEquals((int)1, (int)values.size());
        Assertions.assertNotSame((Object)"linux", values.get(0));
    }
}

