/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.criteria.CriteriaDefinition;
import org.eclipse.help.internal.criteria.CriteriaDefinitionAssembler;
import org.eclipse.help.internal.criteria.CriteriaDefinitionContribution;
import org.eclipse.help.internal.criteria.CriteriaDefinitionFile;
import org.eclipse.help.internal.criteria.CriteriaDefinitionFileParser;
import org.eclipse.help.internal.dynamic.DocumentWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.osgi.framework.FrameworkUtil;

public class ParseCriteriaDefinition {
    @Test
    public void testAssemble() throws Exception {
        CriteriaDefinitionFileParser parser = new CriteriaDefinitionFileParser();
        String bsn = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
        CriteriaDefinitionContribution a = parser.parse(new CriteriaDefinitionFile(bsn, "data/help/criteria/criteria_definition/a.xml", "en"));
        CriteriaDefinitionContribution b = parser.parse(new CriteriaDefinitionFile(bsn, "data/help/criteria/criteria_definition/b.xml", "en"));
        CriteriaDefinitionContribution result_a_b = parser.parse(new CriteriaDefinitionFile(bsn, "data/help/criteria/criteria_definition/result_a_b.xml", "en"));
        CriteriaDefinitionAssembler assembler = new CriteriaDefinitionAssembler();
        ArrayList<CriteriaDefinitionContribution> contributions = new ArrayList<CriteriaDefinitionContribution>(Arrays.asList(a, b));
        CriteriaDefinition assembled = assembler.assemble(contributions);
        String expected = this.serialize((UAElement)result_a_b.getCriteriaDefinition());
        String actual = this.serialize((UAElement)assembled);
        Assertions.assertEquals((Object)this.trimWhiteSpace(expected), (Object)this.trimWhiteSpace(actual));
    }

    private String trimWhiteSpace(String input) {
        StringBuilder result = new StringBuilder();
        boolean betweenElements = false;
        int i = 0;
        while (i < input.length()) {
            char next = input.charAt(i);
            if (betweenElements) {
                if (!Character.isWhitespace(next)) {
                    result.append(next);
                    if (next == '<') {
                        betweenElements = false;
                    }
                }
            } else {
                result.append(next);
                if (next == '>') {
                    betweenElements = true;
                    result.append('\r');
                    result.append('\n');
                }
            }
            ++i;
        }
        String resString = result.toString();
        return resString;
    }

    private String serialize(UAElement element) throws Exception {
        DocumentWriter writer = new DocumentWriter();
        return writer.writeString(element, true);
    }
}

