/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.criteria;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.assertj.core.api.Assertions;
import org.eclipse.help.ICriteria;
import org.eclipse.help.IToc;
import org.eclipse.help.IToc2;
import org.eclipse.help.ITopic;
import org.eclipse.help.ITopic2;
import org.eclipse.help.internal.Topic;
import org.eclipse.help.internal.base.scope.CriteriaHelpScope;
import org.eclipse.help.internal.base.util.CriteriaUtilities;
import org.eclipse.help.internal.criteria.CriterionResource;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.toc.TocContribution;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocFileParser;
import org.eclipse.ua.tests.help.other.UserCriteria;
import org.eclipse.ua.tests.help.other.UserToc2;
import org.eclipse.ua.tests.help.other.UserTopic2;
import org.junit.jupiter.api.Test;
import org.osgi.framework.FrameworkUtil;
import org.xml.sax.SAXException;

public class ParseTocWithCriteria {
    private IToc2 parseToc(String filename) throws IOException, SAXException, ParserConfigurationException {
        TocFileParser parser = new TocFileParser();
        TocContribution cToc = parser.parse(new TocFile(FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), filename, true, "en", null, null));
        IToc toc = cToc.getToc();
        return (IToc2)toc;
    }

    @Test
    public void testTocWithCriteria() throws Exception {
        IToc2 toc = this.parseToc("data/help/criteria/c1.xml");
        HashMap criteria = new HashMap();
        CriteriaUtilities.addCriteriaToMap(criteria, (ICriteria[])toc.getCriteria());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)criteria.size());
        Set versions = (Set)criteria.get("version");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)versions);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)versions.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)versions.contains("1.0"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)versions.contains("2.0"));
        Set platforms = (Set)criteria.get("platform");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)platforms);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)platforms.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)platforms.contains("linux"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)platforms.contains("win32"));
    }

    @Test
    public void testCopyTocWithCriteria() throws Exception {
        IToc2 toc0 = this.parseToc("data/help/criteria/c1.xml");
        Toc toc = new Toc((IToc)toc0);
        HashMap criteria = new HashMap();
        CriteriaUtilities.addCriteriaToMap(criteria, (ICriteria[])toc.getCriteria());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)criteria.size());
        Set versions = (Set)criteria.get("version");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)versions);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)versions.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)versions.contains("1.0"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)versions.contains("2.0"));
        Set platforms = (Set)criteria.get("platform");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)platforms);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)platforms.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)platforms.contains("linux"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)platforms.contains("win32"));
    }

    @Test
    public void testTopicWithCriteria() throws Exception {
        IToc2 toc = this.parseToc("data/help/criteria/c1.xml");
        Object[] topics = toc.getTopics();
        Assertions.assertThat((Object[])topics).hasSize(2);
        HashMap criteria = new HashMap();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(topics[0] instanceof ITopic2));
        CriteriaUtilities.addCriteriaToMap(criteria, (ICriteria[])((ITopic2)topics[0]).getCriteria());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)criteria.size());
        Set versions = (Set)criteria.get("version");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)versions);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)versions.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)versions.contains("1.0"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)versions.contains("2.0"));
        criteria = new HashMap();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(topics[1] instanceof ITopic2));
        CriteriaUtilities.addCriteriaToMap(criteria, (ICriteria[])((ITopic2)topics[1]).getCriteria());
        versions = (Set)criteria.get("version");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)versions);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)versions.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)versions.contains("2.0"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)versions.contains("1.0"));
    }

    @Test
    public void testCriteriaScoping1() throws Exception {
        IToc2 toc = this.parseToc("data/help/criteria/c1.xml");
        Object[] topics = toc.getTopics();
        Assertions.assertThat((Object[])topics).hasSize(2);
        CriterionResource[] resource = new CriterionResource[]{new CriterionResource("version")};
        resource[0].addCriterionValue("1.0");
        CriteriaHelpScope scope = new CriteriaHelpScope(resource);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)scope.inScope((IToc)toc));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)scope.inScope((ITopic)topics[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)scope.inScope((ITopic)topics[1]));
    }

    @Test
    public void testCriteriaScoping2() throws Exception {
        IToc2 toc = this.parseToc("data/help/criteria/c1.xml");
        Object[] topics = toc.getTopics();
        Assertions.assertThat((Object[])topics).hasSize(2);
        CriterionResource[] resource = new CriterionResource[]{new CriterionResource("platform")};
        resource[0].addCriterionValue("linux");
        CriteriaHelpScope scope = new CriteriaHelpScope(resource);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)scope.inScope((IToc)toc));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)scope.inScope((ITopic)topics[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)scope.inScope((ITopic)topics[1]));
    }

    @Test
    public void testMultipleCriteriaScoping() throws Exception {
        IToc2 toc = this.parseToc("data/help/criteria/c1.xml");
        Object[] topics = toc.getTopics();
        Assertions.assertThat((Object[])topics).hasSize(2);
        CriterionResource[] resource = new CriterionResource[2];
        resource[0] = new CriterionResource("platform");
        resource[0].addCriterionValue("linux");
        resource[1] = new CriterionResource("version");
        resource[1].addCriterionValue("1.0");
        CriteriaHelpScope scope = new CriteriaHelpScope(resource);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)scope.inScope((IToc)toc));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)scope.inScope((ITopic)topics[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)scope.inScope((ITopic)topics[1]));
    }

    @Test
    public void testMultipleCriteriaOnlyOneSatisfied() throws Exception {
        IToc2 toc = this.parseToc("data/help/criteria/c1.xml");
        Object[] topics = toc.getTopics();
        CriterionResource[] resource = new CriterionResource[2];
        resource[0] = new CriterionResource("platform");
        resource[0].addCriterionValue("linux");
        resource[1] = new CriterionResource("version");
        resource[1].addCriterionValue("2.0");
        Assertions.assertThat((Object[])topics).hasSize(2);
        CriteriaHelpScope scope = new CriteriaHelpScope(resource);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)scope.inScope((IToc)toc));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)scope.inScope((ITopic)topics[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)scope.inScope((ITopic)topics[1]));
    }

    @Test
    public void testUserTocWithCriteria() throws Exception {
        UserToc2 toc = new UserToc2("myToc", null, true);
        UserCriteria criterion1 = new UserCriteria("version", "1.0", true);
        UserCriteria criterion2 = new UserCriteria("version", "2.0", true);
        toc.addCriterion(criterion1);
        toc.addCriterion(criterion2);
        Object[] criteria = toc.getCriteria();
        Assertions.assertThat((Object[])criteria).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"version", (Object)criteria[0].getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.0", (Object)criteria[0].getValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"version", (Object)criteria[1].getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"2.0", (Object)criteria[1].getValue());
    }

    @Test
    public void testCopyUserTocWithCriteria() throws Exception {
        UserToc2 toc = new UserToc2("myToc", null, true);
        UserCriteria criterion1 = new UserCriteria("version", "1.0", true);
        UserCriteria criterion2 = new UserCriteria("version", "2.0", true);
        toc.addCriterion(criterion1);
        toc.addCriterion(criterion2);
        Toc copy = new Toc((IToc)toc);
        Object[] criteria = copy.getCriteria();
        Assertions.assertThat((Object[])criteria).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"version", (Object)criteria[0].getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.0", (Object)criteria[0].getValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"version", (Object)criteria[1].getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"2.0", (Object)criteria[1].getValue());
    }

    @Test
    public void testUserTopicWithCriteria() throws Exception {
        UserTopic2 topic = new UserTopic2("myToc", null, true);
        UserCriteria criterion1 = new UserCriteria("version", "1.0", true);
        UserCriteria criterion2 = new UserCriteria("version", "2.0", true);
        topic.addCriterion(criterion1);
        topic.addCriterion(criterion2);
        Topic copy = new Topic((ITopic)topic);
        Object[] criteria = copy.getCriteria();
        Assertions.assertThat((Object[])criteria).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"version", (Object)criteria[0].getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.0", (Object)criteria[0].getValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"version", (Object)criteria[1].getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"2.0", (Object)criteria[1].getValue());
    }

    @Test
    public void testCopyUserTopicWithCriteria() throws Exception {
        UserTopic2 topic = new UserTopic2("myToc", null, true);
        UserCriteria criterion1 = new UserCriteria("version", "1.0", true);
        UserCriteria criterion2 = new UserCriteria("version", "2.0", true);
        topic.addCriterion(criterion1);
        topic.addCriterion(criterion2);
        Object[] criteria = topic.getCriteria();
        Assertions.assertThat((Object[])criteria).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"version", (Object)criteria[0].getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.0", (Object)criteria[0].getValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"version", (Object)criteria[1].getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"2.0", (Object)criteria[1].getValue());
    }

    @Test
    public void testMultipleValues() throws Exception {
        IToc2 toc = this.parseToc("data/help/criteria/c2.xml");
        CriterionResource[] linuxResource = new CriterionResource[]{new CriterionResource("platform")};
        linuxResource[0].addCriterionValue("linux");
        CriteriaHelpScope linuxScope = new CriteriaHelpScope(linuxResource);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)linuxScope.inScope((IToc)toc));
        CriterionResource[] win32Resource = new CriterionResource[]{new CriterionResource("platform")};
        win32Resource[0].addCriterionValue("win32");
        CriteriaHelpScope win32scope = new CriteriaHelpScope(win32Resource);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)win32scope.inScope((IToc)toc));
    }

    @Test
    public void testValuesOfDifferentCases() throws Exception {
        IToc2 toc = this.parseToc("data/help/criteria/c2.xml");
        ITopic[] topics = toc.getTopics();
        CriterionResource[] linuxResource = new CriterionResource[]{new CriterionResource("platform")};
        linuxResource[0].addCriterionValue("linux");
        CriteriaHelpScope linuxScope = new CriteriaHelpScope(linuxResource);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)linuxScope.inScope(topics[0]));
    }

    @Test
    public void testValuesWithWhitespace() throws Exception {
        IToc2 toc = this.parseToc("data/help/criteria/c2.xml");
        ITopic[] topics = toc.getTopics();
        CriterionResource[] win32Resource = new CriterionResource[]{new CriterionResource("platform")};
        win32Resource[0].addCriterionValue("win32");
        CriteriaHelpScope win32Scope = new CriteriaHelpScope(win32Resource);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)win32Scope.inScope(topics[1]));
    }

    @Test
    public void testNoName() throws Exception {
        IToc2 toc = this.parseToc("data/help/criteria/c2.xml");
        ITopic[] topics = toc.getTopics();
        CriterionResource[] win32Resource = new CriterionResource[]{new CriterionResource("platform")};
        win32Resource[0].addCriterionValue("win32");
        CriteriaHelpScope win32Scope = new CriteriaHelpScope(win32Resource);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)win32Scope.inScope(topics[2]));
    }

    @Test
    public void testNoValue() throws Exception {
        IToc2 toc = this.parseToc("data/help/criteria/c2.xml");
        ITopic[] topics = toc.getTopics();
        CriterionResource[] win32Resource = new CriterionResource[]{new CriterionResource("platform")};
        win32Resource[0].addCriterionValue("win32");
        CriteriaHelpScope win32Scope = new CriteriaHelpScope(win32Resource);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)win32Scope.inScope(topics[3]));
    }

    @Test
    public void testNoCriteria() throws Exception {
        IToc2 toc = this.parseToc("data/help/criteria/c2.xml");
        ITopic[] topics = toc.getTopics();
        CriterionResource[] win32Resource = new CriterionResource[]{new CriterionResource("platform")};
        win32Resource[0].addCriterionValue("win32");
        CriteriaHelpScope win32Scope = new CriteriaHelpScope(win32Resource);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)win32Scope.inScope(topics[4]));
    }
}

