/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.criteria;

import org.assertj.core.api.Assertions;
import org.eclipse.help.ICriteria;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.Topic;
import org.eclipse.help.internal.base.scope.CriteriaHelpScope;
import org.eclipse.help.internal.criteria.CriteriaProviderRegistry;
import org.eclipse.help.internal.criteria.CriterionResource;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.ua.tests.help.other.UserCriteria;
import org.eclipse.ua.tests.help.other.UserToc2;
import org.eclipse.ua.tests.help.other.UserTopic2;
import org.junit.jupiter.api.Test;

public class TestCriteriaProvider {
    @Test
    public void testUserTopicWithCriteria() throws Exception {
        UserTopic2 topic = new UserTopic2("Topic", null, true);
        UserCriteria criterion1 = new UserCriteria("version", "1.0", true);
        UserCriteria criterion2 = new UserCriteria("version", "2.0", true);
        topic.addCriterion(criterion1);
        topic.addCriterion(criterion2);
        Topic copy = new Topic((ITopic)topic);
        Object[] nativeCriteria = copy.getCriteria();
        Assertions.assertThat((Object[])nativeCriteria).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"version", (Object)nativeCriteria[0].getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.0", (Object)nativeCriteria[0].getValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"version", (Object)nativeCriteria[1].getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"2.0", (Object)nativeCriteria[1].getValue());
        ICriteria[] allCriteria = CriteriaProviderRegistry.getInstance().getAllCriteria((ITopic)copy);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.containsCriterion(allCriteria, "version", "2.0"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.containsCriterion(allCriteria, "version", "1.0"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.containsCriterion(allCriteria, "containsLetter", "c"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.containsCriterion(allCriteria, "containsLetter", "k"));
    }

    @Test
    public void testUserTocWithCriteria() throws Exception {
        UserToc2 toc = new UserToc2("Toc", null, true);
        UserCriteria criterion1 = new UserCriteria("version", "1.0", true);
        UserCriteria criterion2 = new UserCriteria("version", "2.0", true);
        toc.addCriterion(criterion1);
        toc.addCriterion(criterion2);
        Toc copy = new Toc((IToc)toc);
        Object[] nativeCriteria = copy.getCriteria();
        Assertions.assertThat((Object[])nativeCriteria).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"version", (Object)nativeCriteria[0].getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.0", (Object)nativeCriteria[0].getValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"version", (Object)nativeCriteria[1].getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"2.0", (Object)nativeCriteria[1].getValue());
        ICriteria[] allCriteria = CriteriaProviderRegistry.getInstance().getAllCriteria((IToc)copy);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.containsCriterion(allCriteria, "version", "2.0"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.containsCriterion(allCriteria, "version", "1.0"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.containsCriterion(allCriteria, "containsLetter", "c"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.containsCriterion(allCriteria, "containsLetter", "k"));
    }

    @Test
    public void testCriteriaScope() throws Exception {
        UserTopic2 topic = new UserTopic2("Topic", null, true);
        UserCriteria criterion1 = new UserCriteria("version", "1.0", true);
        topic.addCriterion(criterion1);
        CriterionResource resourceC = new CriterionResource("containsletter");
        resourceC.addCriterionValue("c");
        CriteriaHelpScope scopeC = new CriteriaHelpScope(new CriterionResource[]{resourceC});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)scopeC.inScope((ITopic)topic));
        CriterionResource resourceK = new CriterionResource("containsletter");
        resourceK.addCriterionValue("k");
        CriteriaHelpScope scopeK = new CriteriaHelpScope(new CriterionResource[]{resourceK});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)scopeK.inScope((ITopic)topic));
    }

    private boolean containsCriterion(ICriteria[] allCriteria, String name, String value) {
        ICriteria[] iCriteriaArray = allCriteria;
        int n = allCriteria.length;
        int n2 = 0;
        while (n2 < n) {
            ICriteria element = iCriteriaArray[n2];
            if (element.getName().equals(name) && element.getValue().equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

