/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.dynamic;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.help.internal.xhtml.DynamicXHTMLProcessor;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.ua.tests.util.XMLUtil;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.xml.sax.SAXException;

public class DynamicXHTMLProcessorTest {
    @BeforeEach
    public void setUp() throws Exception {
        HelpUIPlugin.getDefault();
    }

    private String process(String path) throws Exception {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream is = this.getProcessedInput(path, bundle);){
            return this.readStream(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected InputStream getProcessedInput(String path, Bundle bundle) throws IOException, SAXException, ParserConfigurationException, TransformerException, TransformerConfigurationException {
        URL url = bundle.getEntry(path);
        if (url == null) {
            throw new IOException("No entry to '" + path + "' could be found or caller does not have the appropriate permissions.");
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = url.openStream();){
            String href = 47L + bundle.getBundleId() + path;
            return DynamicXHTMLProcessor.process((String)href, (InputStream)in, (String)"en", (boolean)true);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String readStream(InputStream is) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStreamReader inputStreamReader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            int len;
            StringBuilder buffer = new StringBuilder();
            char[] cbuf = new char[256];
            do {
                if ((len = inputStreamReader.read(cbuf)) <= 0) continue;
                buffer.append(cbuf, 0, len);
            } while (len >= 0);
            return buffer.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testXhtmlNoCollapseAnchor() throws Exception {
        String processed = this.process("data/help/dynamic/xhtml/emptyAnchor.xhtml");
        ((AbstractIntegerAssert)Assertions.assertThat((int)processed.indexOf("</a>")).as("anchor collapsed in " + processed, new Object[0])).isGreaterThan(0);
    }

    @Test
    public void testXhtmlNoCollapseParagraph() throws Exception {
        String processed = this.process("data/help/dynamic/xhtml/emptyAnchor.xhtml");
        ((AbstractIntegerAssert)Assertions.assertThat((int)processed.indexOf("</p>")).as("paragraph collapsed in " + processed, new Object[0])).isGreaterThan(0);
    }

    @Test
    public void testXhtmlNoCollapseAnchorIC() throws Exception {
        String processed = this.process("data/help/dynamic/xhtml/emptyAnchorWithComment.xhtml");
        ((AbstractIntegerAssert)Assertions.assertThat((int)processed.indexOf("</a>")).as("anchor collapsed in " + processed, new Object[0])).isGreaterThan(0);
    }

    @Test
    public void testXhtmlNoCollapseParagraphIC() throws Exception {
        String processed = this.process("data/help/dynamic/xhtml/emptyAnchorWithComment.xhtml");
        ((AbstractIntegerAssert)Assertions.assertThat((int)processed.indexOf("</p>")).as("paragraph collapsed in " + processed, new Object[0])).isGreaterThan(0);
    }

    @Test
    public void testXhtmlNoCollapseDiv() throws Exception {
        String processed = this.process("data/help/dynamic/xhtml/emptyDiv.xhtml");
        ((AbstractIntegerAssert)Assertions.assertThat((int)processed.indexOf("</div>")).as("div collapsed in " + processed, new Object[0])).isGreaterThan(0);
    }

    @Test
    public void testXhtmlNoCollapseScript() throws Exception {
        String processed = this.process("data/help/dynamic/xhtml/emptyAnchor.xhtml");
        ((AbstractIntegerAssert)Assertions.assertThat((int)processed.indexOf("</div>")).as("div collapsed in " + processed, new Object[0])).isGreaterThan(0);
    }

    @Test
    public void testValidXML() throws Exception {
        String processed = this.process("data/help/dynamic/xhtml/emptyAnchor.xhtml");
        XMLUtil.assertParseableXML(processed);
    }
}

