/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.dynamic;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.HelpEvaluationContext;
import org.eclipse.help.internal.dynamic.DocumentReader;
import org.eclipse.help.internal.dynamic.ExtensionHandler;
import org.eclipse.help.internal.dynamic.FilterHandler;
import org.eclipse.help.internal.dynamic.IncludeHandler;
import org.eclipse.help.internal.dynamic.ProcessorHandler;
import org.eclipse.help.internal.dynamic.XMLProcessor;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.ua.tests.util.FileUtil;
import org.eclipse.ua.tests.util.XMLUtil;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class XMLProcessorTest {
    @BeforeEach
    public void setUp() throws Exception {
        HelpUIPlugin.getDefault();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void xmlProcess(String path) throws Exception {
        DocumentReader reader = new DocumentReader();
        ProcessorHandler[] handlers = new ProcessorHandler[]{new IncludeHandler(reader, Platform.getNL()), new ExtensionHandler(reader, Platform.getNL()), new FilterHandler((IEvaluationContext)HelpEvaluationContext.getContext())};
        XMLProcessor processor = new XMLProcessor(handlers);
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        URL url1 = bundle.getEntry(FileUtil.getResultFile(path));
        if (url1 == null) {
            throw new IOException("No entry to '" + FileUtil.getResultFile(path) + "' could be found or caller does not have the appropriate permissions.");
        }
        URL url2 = bundle.getEntry(path);
        if (url2 == null) {
            throw new IOException("No entry to '" + path + "' could be found or caller does not have the appropriate permissions.");
        }
        Throwable throwable = null;
        Object var9_10 = null;
        try {
            InputStream in = url1.openStream();
            try {
                try (InputStream in2 = processor.process(url2.openStream(), "/" + bundle.getSymbolicName() + "/" + path, "UTF-8");){
                    XMLUtil.assertXMLEquals("XML content was not processed correctly: " + path, in, in2);
                }
                if (in == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void testExtension() throws Exception {
        this.xmlProcess("data/help/dynamic/extension.xml");
    }

    @Test
    public void testFilter() throws Exception {
        this.xmlProcess("data/help/dynamic/filter.xml");
    }

    @Test
    public void testInclude() throws Exception {
        this.xmlProcess("data/help/dynamic/include.xml");
    }

    @Test
    public void testIndex() throws Exception {
        this.xmlProcess("data/help/dynamic/index.xml");
    }

    @Test
    public void testSimple() throws Exception {
        this.xmlProcess("data/help/dynamic/simple.xml");
    }

    @Test
    public void testToc() throws Exception {
        this.xmlProcess("data/help/dynamic/toc.xml");
    }

    @Test
    public void testXhtml() throws Exception {
        this.xmlProcess("data/help/dynamic/xhtml.xml");
    }

    @Test
    public void testEntities() throws Exception {
        this.xmlProcess("data/help/dynamic/entities.xml");
    }
}

