/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.index;

import java.util.ArrayList;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IIndexEntry2;
import org.eclipse.help.internal.Topic;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.dynamic.DocumentWriter;
import org.eclipse.help.internal.index.Index;
import org.eclipse.help.internal.index.IndexAssembler;
import org.eclipse.help.internal.index.IndexContribution;
import org.eclipse.help.internal.index.IndexEntry;
import org.eclipse.help.internal.index.IndexFile;
import org.eclipse.help.internal.index.IndexFileParser;
import org.eclipse.help.internal.index.IndexSee;
import org.junit.jupiter.api.Test;
import org.osgi.framework.FrameworkUtil;
import org.xml.sax.SAXParseException;

public class IndexAssemblerTest {
    @Test
    public void testAssemble() throws Exception {
        IndexFileParser parser = new IndexFileParser();
        String bsn = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
        IndexContribution a = parser.parse(new IndexFile(bsn, "data/help/index/assembler/a.xml", "en"));
        IndexContribution b = parser.parse(new IndexFile(bsn, "data/help/index/assembler/b.xml", "en"));
        IndexContribution c = parser.parse(new IndexFile(bsn, "data/help/index/assembler/c.xml", "en"));
        IndexContribution result_a_b_c = parser.parse(new IndexFile(bsn, "data/help/index/assembler/result_a_b_c.xml", "en"));
        IndexAssembler assembler = new IndexAssembler();
        ArrayList<IndexContribution> contributions = new ArrayList<IndexContribution>(Arrays.asList(a, b, c));
        Index assembled = assembler.assemble(contributions, Platform.getNL());
        String expected = this.serialize((UAElement)result_a_b_c.getIndex());
        String actual = this.serialize((UAElement)assembled);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.trimWhiteSpace(expected), (Object)this.trimWhiteSpace(actual));
    }

    @Test
    public void testAssembleWithSeeAlso() throws Exception {
        IndexFileParser parser = new IndexFileParser();
        IndexContribution contrib = parser.parse(new IndexFile(FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), "data/help/index/assembler/d.xml", "en"));
        IndexAssembler assembler = new IndexAssembler();
        ArrayList<IndexContribution> contributions = new ArrayList<IndexContribution>(Arrays.asList(contrib));
        Index index = assembler.assemble(contributions, Platform.getNL());
        Object[] children = index.getEntries();
        Assertions.assertThat((Object[])children).hasSize(2);
        Object eclipseEntry = children[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)"eclipse", (Object)eclipseEntry.getKeyword());
        Object[] eclipseChildren = eclipseEntry.getChildren();
        Assertions.assertThat((Object[])eclipseChildren).hasSize(4);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(eclipseChildren[0] instanceof Topic));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(eclipseChildren[1] instanceof IndexEntry));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(eclipseChildren[2] instanceof IndexSee));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(eclipseChildren[3] instanceof IndexSee));
        IndexSee seeHelios = (IndexSee)eclipseChildren[2];
        IndexSee seeHeliosRelease = (IndexSee)eclipseChildren[3];
        Assertions.assertThat((Object[])seeHelios.getSubpathElements()).isEmpty();
        Assertions.assertThat((Object[])seeHeliosRelease.getSubpathElements()).hasSize(1);
        Object heliosEntry = children[1];
        org.junit.jupiter.api.Assertions.assertEquals((Object)"helios", (Object)heliosEntry.getKeyword());
        Object[] heliosSees = ((IIndexEntry2)heliosEntry).getSees();
        Assertions.assertThat((Object[])heliosSees).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"eclipse", (Object)heliosSees[0].getKeyword());
    }

    @Test
    public void testTitle() throws Exception {
        IndexFileParser parser = new IndexFileParser();
        IndexContribution contrib = parser.parse(new IndexFile(FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), "data/help/index/assembler/hasTitle.xml", "en"));
        IndexAssembler assembler = new IndexAssembler();
        ArrayList<IndexContribution> contributions = new ArrayList<IndexContribution>(Arrays.asList(contrib));
        Index index = assembler.assemble(contributions, Platform.getNL());
        Object[] children = index.getEntries();
        Assertions.assertThat((Object[])children).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"keyword1", (Object)children[0].getKeyword());
        Object[] topics = children[0].getTopics();
        Assertions.assertThat((Object[])topics).hasSize(3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"topic0", (Object)topics[0].getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"topic1", (Object)topics[1].getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"topic2", (Object)topics[2].getLabel());
    }

    @Test
    public void testInvalid() throws Exception {
        IndexFileParser parser = new IndexFileParser();
        org.junit.jupiter.api.Assertions.assertThrows(SAXParseException.class, () -> {
            IndexContribution contrib = parser.parse(new IndexFile(FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), "data/help/index/assembler/invalid.xml", "en"));
            IndexAssembler assembler = new IndexAssembler();
            ArrayList<IndexContribution> contributions = new ArrayList<IndexContribution>(Arrays.asList(contrib));
            assembler.assemble(contributions, Platform.getNL());
        });
    }

    private String trimWhiteSpace(String input) {
        StringBuilder result = new StringBuilder();
        boolean betweenElements = false;
        int i = 0;
        while (i < input.length()) {
            char next = input.charAt(i);
            if (betweenElements) {
                if (!Character.isWhitespace(next)) {
                    result.append(next);
                    if (next == '<') {
                        betweenElements = false;
                    }
                }
            } else {
                result.append(next);
                if (next == '>') {
                    betweenElements = true;
                    result.append('\r');
                    result.append('\n');
                }
            }
            ++i;
        }
        String resString = result.toString();
        return resString;
    }

    private String serialize(UAElement element) throws Exception {
        DocumentWriter writer = new DocumentWriter();
        return writer.writeString(element, true);
    }
}

