/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.other;

import org.eclipse.help.ITopic;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.eclipse.help.internal.toc.Toc;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConcurrentTocAccess {
    private final boolean checkAttributes = true;
    private final boolean enableTimeout = true;

    private void accessInParallel(int[] dimensions, int numberOfThreads) throws Exception {
        int i;
        Toc toc = this.createToc(dimensions);
        int expectedLeafCount = this.computeNumberOfLeafTopics(dimensions);
        TocVisitor[] visitors = new TocVisitor[numberOfThreads];
        int i2 = 0;
        while (i2 < numberOfThreads) {
            visitors[i2] = new TocVisitor(toc);
            ++i2;
        }
        i2 = 0;
        while (i2 < numberOfThreads) {
            visitors[i2].start();
            ++i2;
        }
        boolean complete = false;
        int iterations = 0;
        do {
            complete = true;
            if (++iterations > 100) {
                Assertions.fail((String)"Test did not complete within 10 seconds");
            }
            i = 0;
            while (i < numberOfThreads) {
                if (visitors[i].isAlive()) {
                    complete = false;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Assertions.fail((String)"Interrupted Exception");
                    }
                }
                ++i;
            }
        } while (!complete);
        i = 0;
        while (i < numberOfThreads) {
            if (visitors[i].exception != null) {
                throw visitors[i].exception;
            }
            Assertions.assertEquals((int)expectedLeafCount, (int)visitors[i].getLeafCount());
            ++i;
        }
    }

    private int traverseToc(Toc toc) {
        int leafNodes = 0;
        ITopic[] children = toc.getTopics();
        int i = 0;
        while (i < children.length) {
            leafNodes += this.traverseTopic(children[i], i);
            ++i;
        }
        return leafNodes;
    }

    private int computeNumberOfLeafTopics(int[] dimensions) {
        int expectedLeaves = 1;
        int[] nArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            int dimension = nArray[n2];
            expectedLeaves *= dimension;
            ++n2;
        }
        return expectedLeaves;
    }

    private int traverseTopic(ITopic topic, int index) {
        String expectedLabel = "topicLabel" + index;
        String expectedHref = "page" + index + ".html";
        String label = topic.getLabel();
        String href = topic.getHref();
        if (!label.equals(expectedLabel)) {
            throw new BadLabelException();
        }
        if (!href.equals(expectedHref)) {
            throw new BadHrefException();
        }
        ITopic[] children = topic.getSubtopics();
        if (children.length == 0) {
            return 1;
        }
        int leafNodes = 0;
        int i = 0;
        while (i < children.length) {
            leafNodes += this.traverseTopic(children[i], i);
            ++i;
        }
        return leafNodes;
    }

    private Toc createToc(int[] dimensions) {
        Document doc;
        String tocSource = new TocGenerator().generateToc(dimensions);
        try {
            doc = LocalEntityResolver.parse((String)tocSource);
        }
        catch (Exception e) {
            Assertions.fail((String)"Exception creating TOC");
            doc = null;
        }
        Element tocElement = (Element)doc.getElementsByTagName("toc").item(0);
        Toc toc = new Toc(tocElement);
        return toc;
    }

    @Test
    public void testFlatTocSize5() throws Exception {
        int[] dimensions = new int[]{5};
        this.accessInParallel(dimensions, 2);
    }

    @Test
    public void testFlatTocSize1000() throws Exception {
        int[] dimensions = new int[]{1000};
        this.accessInParallel(dimensions, 2);
    }

    @Test
    public void testFlatTocSize10000() throws Exception {
        int[] dimensions = new int[]{10000};
        this.accessInParallel(dimensions, 2);
    }

    @Test
    public void testTwoLevelToc() throws Exception {
        int[] dimensions = new int[]{50, 50};
        this.accessInParallel(dimensions, 2);
    }

    @Test
    public void testDeepToc() throws Exception {
        int[] dimensions = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        this.accessInParallel(dimensions, 2);
    }

    @Test
    public void testFlatTocManyThreads() throws Exception {
        int[] dimensions = new int[]{100};
        this.accessInParallel(dimensions, 100);
    }

    private static class BadHrefException
    extends RuntimeException {
        private static final long serialVersionUID = 410319402417607912L;

        private BadHrefException() {
        }
    }

    private static class BadLabelException
    extends RuntimeException {
        private static final long serialVersionUID = -4581518572807575035L;

        private BadLabelException() {
        }
    }

    private static class TocGenerator {
        private int[] dimensions;
        private StringBuilder result;

        private TocGenerator() {
        }

        public String generateToc(int[] dimensions) {
            this.dimensions = dimensions;
            this.result = new StringBuilder();
            this.result.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            this.result.append("<?NLS TYPE=\"org.eclipse.help.toc\"?>\n");
            this.result.append("<toc label=\"Test Toc\" >\n");
            this.generateTopics(0);
            this.result.append("</toc>");
            return this.result.toString();
        }

        private void generateTopics(int depth) {
            if (depth >= this.dimensions.length) {
                return;
            }
            int numChildren = this.dimensions[depth];
            int i = 0;
            while (i < numChildren) {
                this.result.append("<topic label=\"topicLabel" + i + "\" href=\"page" + i + ".html\">\n");
                this.generateTopics(depth + 1);
                this.result.append("</topic>\n");
                ++i;
            }
        }
    }

    private class TocVisitor
    extends Thread {
        private final Toc toc;
        private int leafCount = -2;
        public Exception exception;

        TocVisitor(Toc toc) {
            this.toc = toc;
        }

        @Override
        public void run() {
            try {
                int result = ConcurrentTocAccess.this.traverseToc(this.toc);
                this.setLeafCount(result);
            }
            catch (Exception e) {
                this.setLeafCount(-1);
                this.exception = e;
            }
        }

        public synchronized void setLeafCount(int leafCount) {
            this.leafCount = leafCount;
        }

        public synchronized int getLeafCount() {
            return this.leafCount;
        }
    }
}

