/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.other;

import org.assertj.core.api.Assertions;
import org.eclipse.help.IContext2;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.ui.internal.views.ContextHelpSorter;
import org.junit.jupiter.api.Test;

public class ContextLinkSorter {
    @Test
    public void testSortEmptyArray() {
        ContextHelpSorter sorter = new ContextHelpSorter((IContext2)new TestContext());
        Object[] resources = new TestResource[]{};
        sorter.sort(null, resources);
        Assertions.assertThat((Object[])resources).isEmpty();
    }

    @Test
    public void testSortSingleCategory() {
        ContextHelpSorter sorter = new ContextHelpSorter((IContext2)new TestContext());
        Object[] resources = new TestResource[]{new TestResource("a1", "c1", "http://www.a1.com"), new TestResource("a3", "c1", "http://www.a3.com"), new TestResource("a2", "c1", "http://www.a2.com")};
        sorter.sort(null, resources);
        Assertions.assertThat((Object[])resources).hasSize(3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a1", (Object)((TestResource)resources[0]).getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a3", (Object)((TestResource)resources[1]).getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a2", (Object)((TestResource)resources[2]).getLabel());
    }

    @Test
    public void testSortMultipleCategory() {
        ContextHelpSorter sorter = new ContextHelpSorter((IContext2)new TestContext());
        Object[] resources = new TestResource[]{new TestResource("a1", "c1", "http://www.a1.com"), new TestResource("a3", "c2", "http://www.a3.com"), new TestResource("a2", "c1", "http://www.a2.com"), new TestResource("a9", "c1", "http://www.a1.com"), new TestResource("a5", null, "http://www.a3.com"), new TestResource("a4", "c2", "http://www.a3.com"), new TestResource("a0", "c3", "http://www.a3.com"), new TestResource("a7", null, "http://www.a2.com")};
        sorter.sort(null, resources);
        Assertions.assertThat((Object[])resources).hasSize(8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a1", (Object)((TestResource)resources[0]).getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a2", (Object)((TestResource)resources[1]).getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a9", (Object)((TestResource)resources[2]).getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a3", (Object)((TestResource)resources[3]).getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a4", (Object)((TestResource)resources[4]).getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a5", (Object)((TestResource)resources[5]).getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a7", (Object)((TestResource)resources[6]).getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a0", (Object)((TestResource)resources[7]).getLabel());
    }

    private static class TestContext
    implements IContext2 {
        private TestContext() {
        }

        public String getCategory(IHelpResource topic) {
            if (topic instanceof TestResource) {
                return ((TestResource)topic).getCategory();
            }
            return null;
        }

        public String getStyledText() {
            return null;
        }

        public String getTitle() {
            return null;
        }

        public IHelpResource[] getRelatedTopics() {
            return null;
        }

        public String getText() {
            return null;
        }
    }

    private static class TestResource
    implements IHelpResource {
        private final String category;
        private final String href;
        private final String label;

        public TestResource(String label, String category, String href) {
            this.category = category;
            this.href = href;
            this.label = label;
        }

        public String getHref() {
            return this.href;
        }

        public String getLabel() {
            return this.label;
        }

        public String getCategory() {
            return this.category;
        }
    }
}

