/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.other;

import org.assertj.core.api.Assertions;
import org.eclipse.help.IContext;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.context.Context;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContextMergeTest {
    private static final String ENABLEMENT_CHEATSHEETS = "<enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement>";
    private static final String TOPIC_END = "</topic>";
    private static final String TOPIC_HEAD_ECLIPSE = "<topic href=\"http://www.eclipse.org\" label=\"enabled\">";
    private static final String CONTEXT_DESCRIPTION = "<description>Context Description</description>";
    private static final String CONTEXT_HEAD = "<context id=\"viewer\" title=\"Sample View\">";
    private static final String TOPIC_ECLIPSE = "<topic href=\"http://www.eclipse.org\" label=\"eclipse\"/>";
    private static final String TOPIC_BUGZILLA = "<topic href=\"http://www.eclipse.org/bugzilla\" label=\"bugzilla\"/>";
    private final String TOPIC_WITH_ENABLEMENT = "<topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic>";
    private static final String END_CONTEXT = "</context>";

    private Context createContext(String contextSource) {
        Document doc;
        try {
            doc = LocalEntityResolver.parse((String)contextSource);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"Caught Exception");
            doc = null;
        }
        Context context = new Context((Element)doc.getFirstChild());
        return context;
    }

    @Test
    public void testContextMerge() {
        String contextSource1 = "<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic></context>";
        String contextSource2 = "<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org/bugzilla\" label=\"bugzilla\"/></context>";
        Context context1 = this.createContext("<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic></context>");
        Context context2 = this.createContext("<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org/bugzilla\" label=\"bugzilla\"/></context>");
        context1.mergeContext((IContext)context2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Sample View", (Object)context1.getTitle());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Context Description", (Object)context1.getText());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"viewer", (Object)context1.getId());
        Object[] related = context1.getRelatedTopics();
        Assertions.assertThat((Object[])related).hasSize(3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"eclipse", (Object)related[0].getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"enabled", (Object)related[1].getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bugzilla", (Object)related[2].getLabel());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(related[0] instanceof IUAElement));
        IUAElement topic = (IUAElement)related[1];
        Object[] topicChildren = topic.getChildren();
        Assertions.assertThat((Object[])topicChildren).hasSize(1);
    }
}

