/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.other;

import org.assertj.core.api.Assertions;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.IContext;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.Topic;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpEvaluationContext;
import org.eclipse.help.internal.context.Context;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContextTest {
    private static final String ENABLEMENT_CHEATSHEETS = "<enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement>";
    private static final String ENABLEMENT_INVALID = "<enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement>";
    private static final String FILTER_OUT = "<filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/>";
    private static final String TOPIC_END = "</topic>";
    private static final String TOPIC_HEAD_ECLIPSE = "<topic href=\"http://www.eclipse.org\" label=\"enabled\">";
    private static final String TOPIC_OLD_FILTER_DISABLED = "<topic filter=\"plugin=org.eclipse.ua.invalid\" href=\"www.eclipse.org\" label=\"Transformations and transformation configurations\"/>";
    private static final String CONTEXT_DESCRIPTION = "<description>Context Description</description>";
    private static final String EMPTY_DESCRIPTION = "<description></description>";
    private static final String CONTEXT_HEAD = "<context id=\"viewer\" title=\"Sample View\">";
    private static final String CONTEXT_HEAD_WITH_ATTRIBUTE = "<context id=\"viewer\" title=\"Sample View\" att=\"abc\">";
    private static final String TOPIC_ECLIPSE = "<topic href=\"http://www.eclipse.org\" label=\"eclipse\"/>";
    private static final String TOPIC_WITH_ENABLEMENT = "<topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic>";
    private static final String TOPIC_DISABLED = "<topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement></topic>";
    private static final String TOPIC_FILTER_OUT = "<topic href=\"http://www.eclipse.org\" label=\"enabled\"><filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/></topic>";
    private static final String END_CONTEXT = "</context>";

    @BeforeEach
    public void setUp() throws Exception {
        BaseHelpSystem.setMode((int)0);
    }

    private Context createContext(String contextSource) {
        Document doc;
        try {
            doc = LocalEntityResolver.parse((String)contextSource);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"Caught Exception");
            doc = null;
        }
        Context context = new Context((Element)doc.getFirstChild());
        return context;
    }

    @Test
    public void testSimpleContext() {
        String contextSource = "<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/></context>";
        Context context = this.createContext("<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/></context>");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Sample View", (Object)context.getTitle());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Context Description", (Object)context.getText());
        Object[] related = context.getRelatedTopics();
        Assertions.assertThat((Object[])related).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"eclipse", (Object)related[0].getLabel());
    }

    @Test
    public void testContextWithEnablement() {
        String contextSource = "<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic></context>";
        Context context = this.createContext("<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic></context>");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Sample View", (Object)context.getTitle());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Context Description", (Object)context.getText());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"viewer", (Object)context.getId());
        Object[] related = context.getRelatedTopics();
        Assertions.assertThat((Object[])related).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"enabled", (Object)related[0].getLabel());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(related[0] instanceof IUAElement));
        IUAElement topic = (IUAElement)related[0];
        Object[] topicChildren = topic.getChildren();
        Assertions.assertThat((Object[])topicChildren).hasSize(1);
    }

    @Test
    public void testCopyContext() {
        String contextSource = "<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic></context>";
        Context context = this.createContext("<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic></context>");
        Context context2 = new Context((IContext)context, "new id");
        Context context3 = new Context((IContext)context2, "new id2");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Sample View", (Object)context.getTitle());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Sample View", (Object)context2.getTitle());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Context Description", (Object)context.getText());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Context Description", (Object)context2.getText());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"viewer", (Object)context.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new id", (Object)context2.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new id2", (Object)context3.getId());
        Object[] related = context.getRelatedTopics();
        Assertions.assertThat((Object[])related).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"enabled", (Object)related[0].getLabel());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(related[0] instanceof IUAElement));
        Topic topic = (Topic)related[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://www.eclipse.org", (Object)topic.getHref());
        related = context2.getRelatedTopics();
        Assertions.assertThat((Object[])related).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"enabled", (Object)related[0].getLabel());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(related[0] instanceof IUAElement));
        topic = (Topic)related[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://www.eclipse.org", (Object)topic.getHref());
        related = context3.getRelatedTopics();
        Assertions.assertThat((Object[])related).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"enabled", (Object)related[0].getLabel());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(related[0] instanceof IUAElement));
        topic = (Topic)related[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://www.eclipse.org", (Object)topic.getHref());
    }

    @Test
    public void testEnablement() {
        String contextSource = "<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement></topic><topic filter=\"plugin=org.eclipse.ua.invalid\" href=\"www.eclipse.org\" label=\"Transformations and transformation configurations\"/></context>";
        Context context = this.createContext("<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement></topic><topic filter=\"plugin=org.eclipse.ua.invalid\" href=\"www.eclipse.org\" label=\"Transformations and transformation configurations\"/></context>");
        Object[] related = context.getRelatedTopics();
        Assertions.assertThat((Object[])related).hasSize(3);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related[2]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testOldStyleFilteringOfCopies() {
        String contextSource = "<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic><topic filter=\"plugin=org.eclipse.ua.invalid\" href=\"www.eclipse.org\" label=\"Transformations and transformation configurations\"/></context>";
        Context context1 = this.createContext("<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic><topic filter=\"plugin=org.eclipse.ua.invalid\" href=\"www.eclipse.org\" label=\"Transformations and transformation configurations\"/></context>");
        Context context2 = new Context((IContext)context1, "id");
        Context context3 = new Context((IContext)context2, "id2");
        Object[] related1 = context1.getRelatedTopics();
        Assertions.assertThat((Object[])related1).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related1[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related1[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        Object[] related2 = context2.getRelatedTopics();
        Assertions.assertThat((Object[])related2).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related2[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related2[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        Object[] related3 = context3.getRelatedTopics();
        Assertions.assertThat((Object[])related3).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related3[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related3[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testOldStyleFilteringOfCopies2() {
        String contextSource = "<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic><topic filter=\"plugin=org.eclipse.ua.invalid\" href=\"www.eclipse.org\" label=\"Transformations and transformation configurations\"/></context>";
        Context context1 = this.createContext("<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic><topic filter=\"plugin=org.eclipse.ua.invalid\" href=\"www.eclipse.org\" label=\"Transformations and transformation configurations\"/></context>");
        Context context2 = new Context((IContext)context1, "id");
        Context context3 = new Context((IContext)context1, "id2");
        Object[] related1 = context1.getRelatedTopics();
        Assertions.assertThat((Object[])related1).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related1[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related1[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        Object[] related2 = context2.getRelatedTopics();
        Assertions.assertThat((Object[])related2).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related2[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related2[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        Object[] related3 = context3.getRelatedTopics();
        Assertions.assertThat((Object[])related3).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related3[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related3[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testFilteringOfCopies() {
        String contextSource = "<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic><topic href=\"http://www.eclipse.org\" label=\"enabled\"><filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/></topic></context>";
        Context context1 = this.createContext("<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic><topic href=\"http://www.eclipse.org\" label=\"enabled\"><filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/></topic></context>");
        Context context2 = new Context((IContext)context1, "id");
        Context context3 = new Context((IContext)context2, "id2");
        Object[] related1 = context1.getRelatedTopics();
        Assertions.assertThat((Object[])related1).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related1[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related1[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        Object[] related2 = context2.getRelatedTopics();
        Assertions.assertThat((Object[])related2).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related2[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related2[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        Object[] related3 = context3.getRelatedTopics();
        Assertions.assertThat((Object[])related3).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related3[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related3[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testFilteringOfCopies2() {
        String contextSource = "<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic><topic href=\"http://www.eclipse.org\" label=\"enabled\"><filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/></topic></context>";
        Context context1 = this.createContext("<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic><topic href=\"http://www.eclipse.org\" label=\"enabled\"><filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/></topic></context>");
        Context context2 = new Context((IContext)context1, "id");
        Context context3 = new Context((IContext)context1, "id2");
        Object[] related1 = context1.getRelatedTopics();
        Assertions.assertThat((Object[])related1).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related1[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related1[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        Object[] related2 = context2.getRelatedTopics();
        Assertions.assertThat((Object[])related2).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related2[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related2[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        Object[] related3 = context3.getRelatedTopics();
        Assertions.assertThat((Object[])related3).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related3[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related3[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testEnablementOfCopies() {
        String contextSource = "<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement></topic></context>";
        Context context1 = this.createContext("<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement></topic></context>");
        Context context2 = new Context((IContext)context1, "id");
        Context context3 = new Context((IContext)context2, "id2");
        Object[] related1 = context1.getRelatedTopics();
        Assertions.assertThat((Object[])related1).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related1[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related1[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        Object[] related2 = context2.getRelatedTopics();
        Assertions.assertThat((Object[])related2).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related2[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related2[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        Object[] related3 = context3.getRelatedTopics();
        Assertions.assertThat((Object[])related3).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related3[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related3[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testEnablementOfCopies2() {
        String contextSource = "<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement></topic></context>";
        Context context1 = this.createContext("<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement></topic></context>");
        Context context2 = new Context((IContext)context1, "id");
        Context context3 = new Context((IContext)context1, "id2");
        Object[] related1 = context1.getRelatedTopics();
        Assertions.assertThat((Object[])related1).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related1[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related1[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        Object[] related2 = context2.getRelatedTopics();
        Assertions.assertThat((Object[])related2).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related2[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related2[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        Object[] related3 = context3.getRelatedTopics();
        Assertions.assertThat((Object[])related3).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related3[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related3[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testEnablementOfCopies3() {
        String contextSource = "<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement></topic></context>";
        Context context1 = this.createContext("<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic><topic href=\"http://www.eclipse.org\" label=\"enabled\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement></topic></context>");
        Context context2 = new Context((IContext)context1, "id");
        Context context3 = new Context((IContext)context1, "id2");
        this.deleteAndInsert(context1);
        this.deleteAndInsert(context2);
        this.deleteAndInsert(context3);
    }

    private void deleteAndInsert(Context context) {
        Object[] related = context.getRelatedTopics();
        Assertions.assertThat((Object[])related).hasSize(2);
        Object enabled = related[0];
        context.removeChild((UAElement)enabled);
        related = context.getRelatedTopics();
        Assertions.assertThat((Object[])related).hasSize(1);
        Topic disabled = (Topic)related[0];
        org.junit.jupiter.api.Assertions.assertFalse((boolean)disabled.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        context.insertBefore((UAElement)enabled, (UAElement)disabled);
        related = context.getRelatedTopics();
        Assertions.assertThat((Object[])related).hasSize(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Topic)related[0]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Topic)related[1]).isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testContextWithAttribute() {
        String contextSource = "<context id=\"viewer\" title=\"Sample View\" att=\"abc\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/></context>";
        Context context = this.createContext("<context id=\"viewer\" title=\"Sample View\" att=\"abc\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/></context>");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc", (Object)context.getAttribute("att"));
    }

    @Test
    public void testContextWithoutDescription() {
        String contextSource = "<context id=\"viewer\" title=\"Sample View\"><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/></context>";
        Context context = this.createContext("<context id=\"viewer\" title=\"Sample View\"><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/></context>");
        org.junit.jupiter.api.Assertions.assertNull((Object)context.getText());
    }

    @Test
    public void testContextWithEmptyDescription() {
        String contextSource = "<context id=\"viewer\" title=\"Sample View\"><description></description><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/></context>";
        Context context = this.createContext("<context id=\"viewer\" title=\"Sample View\"><description></description><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/></context>");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)context.getText());
    }

    @Test
    public void testContextWithoutDescriptionSelfCatenation() {
        String contextSource = "<context id=\"viewer\" title=\"Sample View\"><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/></context>";
        Context context1 = this.createContext("<context id=\"viewer\" title=\"Sample View\"><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/></context>");
        Context context2 = this.createContext("<context id=\"viewer\" title=\"Sample View\"><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/></context>");
        context1.mergeContext((IContext)context2);
        org.junit.jupiter.api.Assertions.assertNull((Object)context1.getText());
    }

    @Test
    public void testContextWithoutDescriptionMixedCatenation() {
        String contextSourceEmpty = "<context id=\"viewer\" title=\"Sample View\"><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/></context>";
        String contextSourceWithDesc = "<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/></context>";
        Context context1 = this.createContext("<context id=\"viewer\" title=\"Sample View\"><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/></context>");
        Context context2 = this.createContext("<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/></context>");
        context1.mergeContext((IContext)context2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Context Description", (Object)context1.getText());
        Context context3 = this.createContext("<context id=\"viewer\" title=\"Sample View\"><description>Context Description</description><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/></context>");
        Context context4 = this.createContext("<context id=\"viewer\" title=\"Sample View\"><topic href=\"http://www.eclipse.org\" label=\"eclipse\"/></context>");
        context3.mergeContext((IContext)context4);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Context Description", (Object)context3.getText());
    }
}

