/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.other;

import java.io.InputStream;
import java.io.Reader;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.junit.jupiter.api.Test;
import org.xml.sax.InputSource;

public class EntityResolutionTest {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resolve(String systemId, boolean isSupportedDtd) throws Exception {
        InputSource is = LocalEntityResolver.resolve((String)"publicId", (String)systemId);
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            Reader reader = is.getCharacterStream();
            try {
                try (InputStream stream = is.getByteStream();){
                    int read;
                    if (reader != null) {
                        char[] cbuf = new char[5];
                        read = reader.read(cbuf);
                        reader.close();
                    } else {
                        byte[] buf = new byte[5];
                        read = stream.read(buf);
                    }
                    if (isSupportedDtd) {
                        ((AbstractIntegerAssert)Assertions.assertThat((int)read).as("entity not found", new Object[0])).isGreaterThan(0);
                    } else {
                        ((AbstractIntegerAssert)Assertions.assertThat((int)read).as("unsupported Entity did not return empty stream", new Object[0])).isEqualTo(-1);
                    }
                }
                if (reader == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            reader.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void testXhtml1() throws Exception {
        this.resolve("http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", true);
    }

    @Test
    public void testFramset() throws Exception {
        this.resolve("http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd", true);
    }

    @Test
    public void testFlat() throws Exception {
        this.resolve("http://www.w3.org/TR/xhtml11/DTD/xhtml11-flat.dtd", true);
    }

    @Test
    public void testStrict() throws Exception {
        this.resolve("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", true);
    }

    @Test
    public void testTransitional() throws Exception {
        this.resolve("http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", true);
    }

    @Test
    public void testLat1() throws Exception {
        this.resolve("http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent", true);
    }

    @Test
    public void testSpecial() throws Exception {
        this.resolve("http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent", true);
    }

    @Test
    public void testResolveSymbol() throws Exception {
        this.resolve("http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent", true);
    }

    @Test
    public void testUnsupportedDtds() throws Exception {
        this.resolve("xyz", false);
        this.resolve("", false);
        this.resolve("http://www.w3.org/TR/xhtml2/DTD/xhtml2-transitional.dtd", false);
    }
}

