/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.other;

import org.assertj.core.api.Assertions;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IIndexEntry2;
import org.eclipse.help.internal.Topic;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpEvaluationContext;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.eclipse.help.internal.index.IndexEntry;
import org.eclipse.help.internal.index.IndexSee;
import org.eclipse.ua.tests.help.other.UserIndexEntry;
import org.eclipse.ua.tests.help.other.UserIndexSee;
import org.eclipse.ua.tests.help.other.UserTopic;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IndexEntryTest {
    private static final String ECLIPSE = "eclipse";
    private static final String BUGZILLA = "bugzilla";
    private static final String BUGZILLA_HREF = "https://bugs.eclipse.org/bugs/";
    private static final String INVALID_INSTALLED = "<with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with>";
    private static final String CS_INSTALLED = "<with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with>";
    private static final String ENABLEMENT_CHEATSHEETS = "<enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement>";
    private static final String ENABLEMENT_INVALID = "<enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement>";
    private static final String FILTER_IN = "<filter name = \"plugin\" value = \"org.eclipse.ua.tests\"/>";
    private static final String FILTER_OUT = "<filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/>";
    private static final String NEGATED_FILTER_IN = "<filter name = \"plugin\" value = \"!org.eclipse.ua.tests\"/>";
    private static final String NEGATED_FILTER_OUT = "<filter name = \"plugin\" value = \"!org.eclipse.ua.invalid\"/>";
    private static final String ENTRY_END = "</entry>";
    private static final String ENTRY_HEAD_ECLIPSE = "<entry keyword=\"eclipse\">";
    private static final String ENTRY_ECLIPSE = "<entry keyword=\"eclipse\"/>";
    private static final String ENTRY_BUGZILLA = "<entry keyword=\"bugzilla\"/>";
    private static final String TOPIC_BUGZILLA = "<topic href=\"https://bugs.eclipse.org/bugs/\" label=\"bugzilla\"/>";
    private static final String SEE_ALSO_SDK = "<see keyword=\"sdk\"/>";
    private final String ENTRY_WITH_ENABLEMENT = "<entry keyword=\"eclipse\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></entry>";
    private final String ENTRY_NOT_ENABLED = "<entry keyword=\"eclipse\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement></entry>";
    private final String ENTRY_FILTER_IN = "<entry keyword=\"eclipse\"><filter name = \"plugin\" value = \"org.eclipse.ua.tests\"/></entry>";
    private final String ENTRY_FILTER_OUT = "<entry keyword=\"eclipse\"><filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/></entry>";
    private final String ENTRY_FILTER_MIXED = "<entry keyword=\"eclipse\"><filter name = \"plugin\" value = \"org.eclipse.ua.tests\"/><filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/></entry>";
    private static final String ENTRY_OLD_FILTER = "<entry filter=\"plugin=org.eclipse.ua.tests\"  keyword=\"Transformations and transformation configurations\"/>";
    private static final String ENTRY_OLD_FILTER_DISABLED = "<entry filter=\"plugin=org.eclipse.ua.invalid\"  keyword=\"Transformations and transformation configurations\"/>";
    private static final String ENTRY_OLD_FILTER_IN__NEGATED = "<entry filter=\"plugin!=org.eclipse.ua.tests\"  keyword=\"Transformations and transformation configurations\"/>";
    private static final String ENTRY_OLD_FILTER_OUT_NEGATED = "<entry filter=\"plugin!=org.eclipse.ua.invalid\"  keyword=\"Transformations and transformation configurations\"/>";
    private final String ENTRY_WITH_CHILD = "<entry keyword=\"eclipse\"><entry keyword=\"bugzilla\"/></entry>";
    private final String ENTRY_WITH_TOPIC = "<entry keyword=\"eclipse\"><topic href=\"https://bugs.eclipse.org/bugs/\" label=\"bugzilla\"/></entry>";
    private final String ENTRY_WITH_SEE = "<entry keyword=\"eclipse\"><see keyword=\"sdk\"/></entry>";

    @BeforeEach
    public void setUp() throws Exception {
        BaseHelpSystem.setMode((int)0);
    }

    private IndexEntry createEntry(String elementSource) {
        Document doc;
        try {
            doc = LocalEntityResolver.parse((String)elementSource);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"Caught Exception");
            doc = null;
        }
        IndexEntry element = new IndexEntry((Element)doc.getFirstChild());
        return element;
    }

    @Test
    public void testSimpleIndexEntry() {
        IndexEntry entry = this.createEntry(ENTRY_ECLIPSE);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)entry.getKeyword());
        Assertions.assertThat((Object[])entry.getTopics()).isEmpty();
        Assertions.assertThat((Object[])entry.getSubentries()).isEmpty();
        Assertions.assertThat((Object[])entry.getSees()).isEmpty();
    }

    @Test
    public void testCopySimpleIndexEntry() {
        IndexEntry entry1 = this.createEntry(ENTRY_ECLIPSE);
        IndexEntry entry2 = new IndexEntry((IIndexEntry)entry1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)entry1.getKeyword());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)entry2.getKeyword());
    }

    @Test
    public void testCopyIndexEntryWithChild() {
        IndexEntry entry1 = this.createEntry("<entry keyword=\"eclipse\"><entry keyword=\"bugzilla\"/></entry>");
        IndexEntry entry2 = new IndexEntry((IIndexEntry)entry1);
        Assertions.assertThat((Object[])entry1.getSubentries()).hasSize(1);
        IndexEntry child1 = (IndexEntry)entry1.getSubentries()[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA, (Object)child1.getKeyword());
        Assertions.assertThat((Object[])entry2.getSubentries()).hasSize(1);
        IndexEntry child2 = (IndexEntry)entry2.getSubentries()[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA, (Object)child2.getKeyword());
        Assertions.assertThat((Object[])entry2.getSubentries()).hasSize(1);
    }

    @Test
    public void testCopyIndexEntryWithTopic() {
        IndexEntry entry1 = this.createEntry("<entry keyword=\"eclipse\"><topic href=\"https://bugs.eclipse.org/bugs/\" label=\"bugzilla\"/></entry>");
        IndexEntry entry2 = new IndexEntry((IIndexEntry)entry1);
        Assertions.assertThat((Object[])entry1.getSubentries()).isEmpty();
        Assertions.assertThat((Object[])entry1.getTopics()).hasSize(1);
        Topic child1 = (Topic)entry1.getTopics()[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA, (Object)child1.getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA_HREF, (Object)child1.getHref());
        Assertions.assertThat((Object[])entry2.getSubentries()).isEmpty();
        Assertions.assertThat((Object[])entry2.getTopics()).hasSize(1);
        Topic child2 = (Topic)entry2.getTopics()[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA, (Object)child2.getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA_HREF, (Object)child2.getHref());
    }

    @Test
    public void testCopyIndexEntryWithSee() {
        IndexEntry entry1 = this.createEntry("<entry keyword=\"eclipse\"><see keyword=\"sdk\"/></entry>");
        IndexEntry entry2 = new IndexEntry((IIndexEntry)entry1);
        Assertions.assertThat((Object[])entry1.getSubentries()).isEmpty();
        Assertions.assertThat((Object[])entry1.getSees()).hasSize(1);
        IndexSee child1 = (IndexSee)entry1.getSees()[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)"sdk", (Object)child1.getKeyword());
        Assertions.assertThat((Object[])entry2.getSubentries()).isEmpty();
        Assertions.assertThat((Object[])entry2.getSees()).hasSize(1);
        IndexSee child2 = (IndexSee)entry2.getSees()[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)"sdk", (Object)child2.getKeyword());
    }

    @Test
    public void testEnabledIndexEntry() {
        IndexEntry entry = this.createEntry("<entry keyword=\"eclipse\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></entry>");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)entry.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testDisabledIndexEntry() {
        IndexEntry entry = this.createEntry("<entry keyword=\"eclipse\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement></entry>");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)entry.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testCopyDisabledIndexEntry() {
        IndexEntry entry1 = this.createEntry("<entry keyword=\"eclipse\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement></entry>");
        IndexEntry entry2 = new IndexEntry((IIndexEntry)entry1);
        IndexEntry entry3 = new IndexEntry((IIndexEntry)entry2);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)entry1.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)entry2.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)entry3.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testCompoundEnablement() {
        IndexEntry entry = this.createEntry("<entry keyword=\"eclipse\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement></entry>");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)entry.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        entry = this.createEntry("<entry keyword=\"eclipse\"><enablement><and><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></and></enablement></entry>");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)entry.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testOldStyleEnablement() {
        IndexEntry entry = this.createEntry(ENTRY_OLD_FILTER);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)entry.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testOldStyleDisabled() {
        IndexEntry entry = this.createEntry(ENTRY_OLD_FILTER_DISABLED);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)entry.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testOldStyleNegated() {
        IndexEntry entry = this.createEntry(ENTRY_OLD_FILTER_IN__NEGATED);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)entry.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        entry = this.createEntry(ENTRY_OLD_FILTER_OUT_NEGATED);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)entry.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testCopyOldStyleDisabled() {
        IndexEntry entry1 = this.createEntry(ENTRY_OLD_FILTER_DISABLED);
        IndexEntry entry2 = new IndexEntry((IIndexEntry)entry1);
        IndexEntry entry3 = new IndexEntry((IIndexEntry)entry2);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)entry1.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)entry2.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)entry3.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testFilterIn() {
        IndexEntry entry = this.createEntry("<entry keyword=\"eclipse\"><filter name = \"plugin\" value = \"org.eclipse.ua.tests\"/></entry>");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)entry.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testFilterOut() {
        IndexEntry entry = this.createEntry("<entry keyword=\"eclipse\"><filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/></entry>");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)entry.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testFilterMixed() {
        IndexEntry entry = this.createEntry("<entry keyword=\"eclipse\"><filter name = \"plugin\" value = \"org.eclipse.ua.tests\"/><filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/></entry>");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)entry.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testNegatedFilters() {
        IndexEntry entry = this.createEntry("<entry keyword=\"eclipse\"><filter name = \"plugin\" value = \"!org.eclipse.ua.tests\"/></entry>");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)entry.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        entry = this.createEntry("<entry keyword=\"eclipse\"><filter name = \"plugin\" value = \"!org.eclipse.ua.invalid\"/></entry>");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)entry.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testCopyFilterOut() {
        IndexEntry entry1 = this.createEntry("<entry keyword=\"eclipse\"><filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/></entry>");
        IndexEntry entry2 = new IndexEntry((IIndexEntry)entry1);
        IndexEntry entry3 = new IndexEntry((IIndexEntry)entry2);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)entry1.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)entry2.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)entry3.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testUserEntry() {
        UserIndexEntry u1 = this.createUserEntry();
        this.checkEntryChildEnablement(u1);
        IndexEntry entry = new IndexEntry((IIndexEntry)u1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"java", (Object)entry.getKeyword());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)entry.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        this.checkCreatedEntry((IIndexEntry2)entry);
    }

    @Test
    public void testUserEntryChildEnablement() {
        UserIndexEntry u1 = this.createUserEntry();
        IndexEntry entry = new IndexEntry((IIndexEntry)u1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"java", (Object)entry.getKeyword());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)entry.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        this.checkEntryChildEnablement((IIndexEntry2)entry);
    }

    @Test
    public void testCopyUserEntry() {
        UserIndexEntry u1 = this.createUserEntry();
        IndexEntry entry1 = new IndexEntry((IIndexEntry)u1);
        IndexEntry entry2 = new IndexEntry((IIndexEntry)entry1);
        this.checkCreatedEntry((IIndexEntry2)entry1);
        this.checkCreatedEntry((IIndexEntry2)entry2);
    }

    private void checkCreatedEntry(IIndexEntry2 entry) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"java", (Object)entry.getKeyword());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)entry.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        Object[] subentries = entry.getSubentries();
        Object[] topics = entry.getTopics();
        Object[] sees = entry.getSees();
        Assertions.assertThat((Object[])subentries).hasSize(2);
        Assertions.assertThat((Object[])sees).hasSize(1);
        Assertions.assertThat((Object[])topics).hasSize(3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"jdt", (Object)subentries[0].getKeyword());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"compiler", (Object)subentries[1].getKeyword());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"label1", (Object)topics[0].getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"label2", (Object)topics[1].getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"label3", (Object)topics[2].getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"href1", (Object)topics[0].getHref());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"href2", (Object)topics[1].getHref());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"href3", (Object)topics[2].getHref());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"beans", (Object)sees[0].getKeyword());
    }

    private void checkEntryChildEnablement(IIndexEntry2 entry) {
        Object[] subentries = entry.getSubentries();
        Object[] topics = entry.getTopics();
        Object[] sees = entry.getSees();
        Assertions.assertThat((Object[])subentries).hasSize(2);
        Assertions.assertThat((Object[])sees).hasSize(1);
        Assertions.assertThat((Object[])topics).hasSize(3);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)subentries[0].isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)subentries[1].isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)topics[0].isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topics[1].isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)topics[2].isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sees[0].isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    private UserIndexEntry createUserEntry() {
        UserIndexEntry u1 = new UserIndexEntry("java", true);
        UserIndexEntry u2 = new UserIndexEntry("jdt", true);
        UserIndexEntry u3 = new UserIndexEntry("compiler", false);
        UserTopic t1 = new UserTopic("label1", "href1", true);
        UserTopic t2 = new UserTopic("label2", "href2", false);
        UserTopic t3 = new UserTopic("label3", "href3", true);
        UserIndexSee s1 = new UserIndexSee("beans", true);
        u1.addEntry((IIndexEntry)u2);
        u1.addEntry((IIndexEntry)u3);
        u1.addTopic(t1);
        u1.addTopic(t2);
        u1.addTopic(t3);
        u1.addSee(s1);
        return u1;
    }
}

