/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.other;

import org.assertj.core.api.Assertions;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IIndexSee;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.eclipse.help.internal.index.IndexEntry;
import org.eclipse.help.internal.index.IndexSee;
import org.eclipse.ua.tests.help.other.UserIndexEntry;
import org.eclipse.ua.tests.help.other.UserIndexSee;
import org.eclipse.ua.tests.help.other.UserIndexSubpath;
import org.eclipse.ua.tests.help.other.UserTopic;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IndexSeeTest {
    private static final String AGUILA = "\u00e1guila";
    private static final String ECLIPSE = "eclipse";
    private static final String SDK = "sdk";
    private static final String VIEWS = "views";
    private static final String SEE_END = "</see>";
    private static final String SEE_HEAD_ECLIPSE = "<see keyword=\"eclipse\">";
    private static final String SEE_ECLIPSE = "<see keyword=\"eclipse\"/>";
    private static final String SEE_SDK = "<see keyword=\"sdk\"/>";
    private static final String SUBPATH_SDK = "<subpath keyword=\"sdk\">";
    private static final String SUBPATH_VIEWS = "<subpath keyword=\"views\">";
    private static final String SUBPATH_END = "</subpath>";
    private static final String SEE_ECLIPSE_SDK = "<see keyword=\"eclipse\"><subpath keyword=\"sdk\"></subpath></see>";
    private static final String SEE_ECLIPSE_VIEWS = "<see keyword=\"eclipse\"><subpath keyword=\"sdk\"></subpath><subpath keyword=\"views\"></subpath></see>";
    private static final String SEE_ECLIPSE_SDK_VIEWS = "<see keyword=\"eclipse\"><subpath keyword=\"sdk\"></subpath><subpath keyword=\"views\"></subpath></see>";

    @BeforeEach
    public void setUp() throws Exception {
        BaseHelpSystem.setMode((int)0);
    }

    private IndexSee createSee(String elementSource) {
        Document doc;
        try {
            doc = LocalEntityResolver.parse((String)elementSource);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"Caught Exception");
            doc = null;
        }
        IndexSee element = new IndexSee((Element)doc.getFirstChild());
        return element;
    }

    private IndexSee createSimpleSee(String keyword) {
        Document doc;
        String elementSource = "<see keyword=\"" + keyword + "\" />";
        try {
            doc = LocalEntityResolver.parse((String)elementSource);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"Caught Exception");
            doc = null;
        }
        IndexSee element = new IndexSee((Element)doc.getFirstChild());
        return element;
    }

    @Test
    public void testSimpleIndexSee() {
        IndexSee see = this.createSee(SEE_ECLIPSE);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)see.getKeyword());
    }

    @Test
    public void testCopySimpleIndexSee() {
        IndexSee see1 = this.createSee(SEE_ECLIPSE);
        IndexSee see2 = new IndexSee((IIndexSee)see1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)see1.getKeyword());
        Assertions.assertThat((Object[])see1.getSubpathElements()).isEmpty();
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)see1.getKeyword());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)see2.getKeyword());
        Assertions.assertThat((Object[])see2.getSubpathElements()).isEmpty();
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)see2.getKeyword());
    }

    @Test
    public void testCopyIndexSeeWithSubpath() {
        IndexSee see1 = this.createSee(SEE_ECLIPSE_SDK);
        IndexSee see2 = new IndexSee((IIndexSee)see1);
        Assertions.assertThat((Object[])see1.getSubpathElements()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)see1.getKeyword());
        org.junit.jupiter.api.Assertions.assertEquals((Object)SDK, (Object)see1.getSubpathElements()[0].getKeyword());
        Assertions.assertThat((Object[])see2.getSubpathElements()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)see2.getKeyword());
        org.junit.jupiter.api.Assertions.assertEquals((Object)SDK, (Object)see2.getSubpathElements()[0].getKeyword());
    }

    @Test
    public void testCopyIndexSeeWithLongerSubpath() {
        IndexSee see1 = this.createSee("<see keyword=\"eclipse\"><subpath keyword=\"sdk\"></subpath><subpath keyword=\"views\"></subpath></see>");
        IndexSee see2 = new IndexSee((IIndexSee)see1);
        Assertions.assertThat((Object[])see1.getSubpathElements()).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)see1.getKeyword());
        org.junit.jupiter.api.Assertions.assertEquals((Object)SDK, (Object)see1.getSubpathElements()[0].getKeyword());
        org.junit.jupiter.api.Assertions.assertEquals((Object)VIEWS, (Object)see1.getSubpathElements()[1].getKeyword());
        Assertions.assertThat((Object[])see2.getSubpathElements()).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)see2.getKeyword());
        org.junit.jupiter.api.Assertions.assertEquals((Object)SDK, (Object)see2.getSubpathElements()[0].getKeyword());
        org.junit.jupiter.api.Assertions.assertEquals((Object)VIEWS, (Object)see2.getSubpathElements()[1].getKeyword());
    }

    @Test
    public void testCompareSimpleSame() {
        IndexSee see1 = this.createSee(SEE_ECLIPSE);
        IndexSee see2 = this.createSee(SEE_ECLIPSE);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)see1.equals((Object)see2));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)see1.compareTo((Object)see2));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)see2.compareTo((Object)see1));
        org.junit.jupiter.api.Assertions.assertEquals((int)see1.hashCode(), (int)see2.hashCode());
    }

    @Test
    public void testCompareSimpleDifferent() {
        IndexSee see1 = this.createSee(SEE_ECLIPSE);
        IndexSee see2 = this.createSee(SEE_SDK);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)see1.equals((Object)see2));
        org.junit.jupiter.api.Assertions.assertTrue((see1.compareTo((Object)see2) < 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((see2.compareTo((Object)see1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareCompoundSame() {
        IndexSee see1 = this.createSee(SEE_ECLIPSE_SDK);
        IndexSee see2 = this.createSee(SEE_ECLIPSE_SDK);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)see1.equals((Object)see2));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)see1.compareTo((Object)see2));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)see2.compareTo((Object)see1));
        org.junit.jupiter.api.Assertions.assertEquals((int)see1.hashCode(), (int)see2.hashCode());
    }

    @Test
    public void testCompareCompoundDifferent() {
        IndexSee see1 = this.createSee(SEE_ECLIPSE_SDK);
        IndexSee see2 = this.createSee("<see keyword=\"eclipse\"><subpath keyword=\"sdk\"></subpath><subpath keyword=\"views\"></subpath></see>");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)see1.equals((Object)see2));
        org.junit.jupiter.api.Assertions.assertTrue((see1.compareTo((Object)see2) < 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((see2.compareTo((Object)see1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareCompoundDifferentLengths() {
        IndexSee see1 = this.createSee(SEE_ECLIPSE_SDK);
        IndexSee see2 = this.createSee("<see keyword=\"eclipse\"><subpath keyword=\"sdk\"></subpath><subpath keyword=\"views\"></subpath></see>");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)see1.equals((Object)see2));
        org.junit.jupiter.api.Assertions.assertTrue((see1.compareTo((Object)see2) < 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((see2.compareTo((Object)see1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare_AAA_abacus() {
        IndexSee see1 = this.createSimpleSee("AAA");
        IndexSee see2 = this.createSimpleSee("abacus");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)see1.equals((Object)see2));
        org.junit.jupiter.api.Assertions.assertTrue((see1.compareTo((Object)see2) < 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((see2.compareTo((Object)see1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare_abacus_ABC() {
        IndexSee see1 = this.createSimpleSee("abacus");
        IndexSee see2 = this.createSimpleSee(AGUILA);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)see1.equals((Object)see2));
        org.junit.jupiter.api.Assertions.assertTrue((see1.compareTo((Object)see2) < 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((see2.compareTo((Object)see1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare_ABC_aguila() {
        IndexSee see1 = this.createSimpleSee("ABC");
        IndexSee see2 = this.createSimpleSee(AGUILA);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)see1.equals((Object)see2));
        org.junit.jupiter.api.Assertions.assertTrue((see1.compareTo((Object)see2) < 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((see2.compareTo((Object)see1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare_aguila_axe() {
        IndexSee see1 = this.createSimpleSee(AGUILA);
        IndexSee see2 = this.createSimpleSee("axe");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)see1.equals((Object)see2));
        org.junit.jupiter.api.Assertions.assertTrue((see1.compareTo((Object)see2) < 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((see2.compareTo((Object)see1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare_to_underscore() {
        IndexSee see1 = this.createSimpleSee("abc");
        IndexSee see2 = this.createSimpleSee("_xyz");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)see1.equals((Object)see2));
        org.junit.jupiter.api.Assertions.assertTrue((see1.compareTo((Object)see2) > 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((see2.compareTo((Object)see1) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUserSee() {
        UserIndexSee u1 = this.createUserSee();
        IndexSee see = new IndexSee((IIndexSee)u1);
        this.checkCreatedSee(see);
    }

    @Test
    public void testCopyUserSee() {
        UserIndexSee u1 = this.createUserSee();
        IndexSee see = new IndexSee((IIndexSee)u1);
        IndexSee see2 = new IndexSee((IIndexSee)see);
        this.checkCreatedSee(see);
        this.checkCreatedSee(see2);
    }

    @Test
    public void testCreateTwiceUserSee() {
        UserIndexSee u1 = this.createUserSee();
        IndexSee see = new IndexSee((IIndexSee)u1);
        IndexSee see2 = new IndexSee((IIndexSee)u1);
        this.checkCreatedSee(see);
        this.checkCreatedSee(see2);
    }

    @Test
    public void testSeeAlsoWithSiblingTopic() {
        UserIndexEntry entry = new UserIndexEntry("test", true);
        UserTopic topic = new UserTopic("label", "href.html", true);
        entry.addTopic(topic);
        UserIndexSee see = new UserIndexSee("check", true);
        entry.addSee(see);
        IndexEntry indexEntry = new IndexEntry((IIndexEntry)entry);
        IIndexSee[] sees = indexEntry.getSees();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((IndexSee)sees[0]).isSeeAlso());
    }

    @Test
    public void testSeeAlsoWithSiblingEntry() {
        UserIndexEntry entry = new UserIndexEntry("test", true);
        UserIndexEntry subEntry = new UserIndexEntry("case", true);
        UserTopic topic = new UserTopic("label", "href.html", true);
        entry.addEntry((IIndexEntry)subEntry);
        subEntry.addTopic(topic);
        UserIndexSee see = new UserIndexSee("check", true);
        entry.addSee(see);
        IndexEntry indexEntry = new IndexEntry((IIndexEntry)entry);
        IIndexSee[] sees = indexEntry.getSees();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((IndexSee)sees[0]).isSeeAlso());
    }

    @Test
    public void testSiblingSeesNotSeeAlso() {
        UserIndexEntry entry = new UserIndexEntry("test", true);
        UserIndexSee see1 = new UserIndexSee("check", true);
        entry.addSee(see1);
        UserIndexSee see2 = new UserIndexSee("verify", true);
        entry.addSee(see2);
        IndexEntry indexEntry = new IndexEntry((IIndexEntry)entry);
        IIndexSee[] sees = indexEntry.getSees();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((IndexSee)sees[0]).isSeeAlso());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((IndexSee)sees[1]).isSeeAlso());
    }

    private UserIndexSee createUserSee() {
        UserIndexSee u1 = new UserIndexSee(ECLIPSE, false);
        UserIndexSubpath u2 = new UserIndexSubpath("platform");
        UserIndexSubpath u3 = new UserIndexSubpath("ui");
        u1.addSubpath(u2);
        u1.addSubpath(u3);
        return u1;
    }

    private void checkCreatedSee(IndexSee see) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)see.getKeyword());
        Object[] subpath = see.getSubpathElements();
        Assertions.assertThat((Object[])subpath).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"platform", (Object)subpath[0].getKeyword());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ui", (Object)subpath[1].getKeyword());
    }
}

