/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.other;

import org.eclipse.help.internal.base.util.LinkUtil;
import org.eclipse.ui.internal.cheatsheets.views.ViewUtilities;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LinkUtilTest {
    @Test
    public void testStripParamNull() {
        Assertions.assertEquals(null, (Object)LinkUtil.stripParams(null));
    }

    @Test
    public void testStripParamEmpty() {
        Assertions.assertEquals((Object)"", (Object)ViewUtilities.escapeForLabel((String)""));
    }

    @Test
    public void testStripParamWithoutParam() {
        Assertions.assertEquals((Object)"http://www.eclipse.org", (Object)LinkUtil.stripParams((String)"http://www.eclipse.org"));
    }

    @Test
    public void testStripParamWithParam() {
        Assertions.assertEquals((Object)"http://www.mysite.com", (Object)LinkUtil.stripParams((String)"http://www.mysite.com?param1=foo&param2=bar"));
    }

    @Test
    public void testStripParamWithAnchor() {
        Assertions.assertEquals((Object)"http://www.mysite.com#anchor1", (Object)LinkUtil.stripParams((String)"http://www.mysite.com#anchor1"));
    }

    @Test
    public void testStripParamWithAnchorBeforeParam() {
        Assertions.assertEquals((Object)"http://www.mysite.com#anchor1", (Object)LinkUtil.stripParams((String)"http://www.mysite.com#anchor1?param=foobar"));
    }

    @Test
    public void testStripParamWithAnchorAfterParam() {
        Assertions.assertEquals((Object)"http://www.mysite.com#anchor1", (Object)LinkUtil.stripParams((String)"http://www.mysite.com?param=foobar#anchor1"));
    }
}

