/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.other;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.util.ProductPreferences;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;

public class PathResolutionTest {
    @Test
    public void testResolveNull() {
        Assertions.assertEquals(null, (Object)ProductPreferences.resolveSpecialIdentifiers(null));
    }

    @Test
    public void testResolveSimplePath() {
        Assertions.assertEquals((Object)"/a.b.c/toc.xml", (Object)ProductPreferences.resolveSpecialIdentifiers((String)"/a.b.c/toc.xml"));
    }

    @Test
    public void testResolvePluginsRoot() {
        Assertions.assertEquals((Object)"/a.b.c/toc.xml", (Object)ProductPreferences.resolveSpecialIdentifiers((String)"PLUGINS_ROOT/a.b.c/toc.xml"));
    }

    @Test
    public void testResolveSlashPluginsRoot() {
        Assertions.assertEquals((Object)"/a.b.c/toc.xml", (Object)ProductPreferences.resolveSpecialIdentifiers((String)"/PLUGINS_ROOT/a.b.c/toc.xml"));
    }

    @Test
    public void testResolveEmbeddedPluginsRoot() {
        Assertions.assertEquals((Object)"/a.b.c/toc.xml", (Object)ProductPreferences.resolveSpecialIdentifiers((String)"../PLUGINS_ROOT/a.b.c/toc.xml"));
    }

    @Test
    public void testResolvePluginsRootProductPlugin() {
        Bundle productBundle;
        IProduct product = Platform.getProduct();
        if (product != null && (productBundle = product.getDefiningBundle()) != null) {
            String bundleName = productBundle.getSymbolicName();
            Assertions.assertEquals((Object)("/" + bundleName + "/toc.xml"), (Object)ProductPreferences.resolveSpecialIdentifiers((String)"PLUGINS_ROOT/PRODUCT_PLUGIN/toc.xml"));
        }
    }

    @Test
    public void testResolveProductPlugin() {
        Bundle productBundle;
        IProduct product = Platform.getProduct();
        if (product != null && (productBundle = product.getDefiningBundle()) != null) {
            String bundleName = productBundle.getSymbolicName();
            Assertions.assertEquals((Object)("/" + bundleName + "/toc.xml"), (Object)ProductPreferences.resolveSpecialIdentifiers((String)"PRODUCT_PLUGIN/toc.xml"));
        }
    }

    @Test
    public void testResolveSlashProductPlugin() {
        Bundle productBundle;
        IProduct product = Platform.getProduct();
        if (product != null && (productBundle = product.getDefiningBundle()) != null) {
            String bundleName = productBundle.getSymbolicName();
            Assertions.assertEquals((Object)("/" + bundleName + "/toc.xml"), (Object)ProductPreferences.resolveSpecialIdentifiers((String)"/PRODUCT_PLUGIN/toc.xml"));
        }
    }
}

