/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.other;

import org.eclipse.help.ui.internal.util.EscapeUtils;
import org.eclipse.ui.internal.cheatsheets.views.ViewUtilities;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEscapeUtils {
    @Test
    public void testEscapeEmpty() {
        Assertions.assertEquals((Object)"", (Object)EscapeUtils.escapeSpecialChars((String)""));
        Assertions.assertEquals((Object)"", (Object)EscapeUtils.escapeSpecialCharsLeavinggBold((String)""));
    }

    @Test
    public void testEscapeSimple() {
        Assertions.assertEquals((Object)"abc", (Object)EscapeUtils.escapeSpecialChars((String)"abc"));
        Assertions.assertEquals((Object)"abc", (Object)EscapeUtils.escapeSpecialCharsLeavinggBold((String)"abc"));
    }

    @Test
    public void testEscapeTabs() {
        Assertions.assertEquals((Object)"a  bc", (Object)EscapeUtils.escapeSpecialChars((String)"a\t\tbc"));
        Assertions.assertEquals((Object)"a  bc", (Object)EscapeUtils.escapeSpecialCharsLeavinggBold((String)"a\t\tbc"));
    }

    @Test
    public void testEscapeAmpersand() {
        Assertions.assertEquals((Object)"&amp;1&amp;", (Object)EscapeUtils.escapeSpecialChars((String)"&1&"));
        Assertions.assertEquals((Object)"&amp;1&amp;", (Object)EscapeUtils.escapeSpecialCharsLeavinggBold((String)"&1&"));
        Assertions.assertEquals((Object)"&amp;1&amp;", (Object)EscapeUtils.escapeAmpersand((String)"&1&"));
    }

    @Test
    public void testEscapeQuotes() {
        Assertions.assertEquals((Object)"&quot;&quot;&apos;&apos;", (Object)EscapeUtils.escapeSpecialChars((String)"\"\"''"));
        Assertions.assertEquals((Object)"&quot;&quot;&apos;&apos;", (Object)EscapeUtils.escapeSpecialCharsLeavinggBold((String)"\"\"''"));
    }

    @Test
    public void testEscapePTag() {
        Assertions.assertEquals((Object)"&lt;p&gt;", (Object)EscapeUtils.escapeSpecialChars((String)"<p>"));
        Assertions.assertEquals((Object)"&lt;p&gt;", (Object)EscapeUtils.escapeSpecialCharsLeavinggBold((String)"<p>"));
    }

    @Test
    public void testEscapeLowerBTag() {
        Assertions.assertEquals((Object)"&lt;b&gt;", (Object)EscapeUtils.escapeSpecialChars((String)"<b>"));
        Assertions.assertEquals((Object)"<b>", (Object)EscapeUtils.escapeSpecialCharsLeavinggBold((String)"<b>"));
    }

    @Test
    public void testEscapeUpperBTag() {
        Assertions.assertEquals((Object)"&lt;B&gt;", (Object)EscapeUtils.escapeSpecialChars((String)"<B>"));
        Assertions.assertEquals((Object)"<B>", (Object)EscapeUtils.escapeSpecialCharsLeavinggBold((String)"<B>"));
    }

    @Test
    public void testEscapeClosingBTag() {
        Assertions.assertEquals((Object)"&lt;/b&gt;", (Object)EscapeUtils.escapeSpecialChars((String)"</b>"));
        Assertions.assertEquals((Object)"</b>", (Object)EscapeUtils.escapeSpecialCharsLeavinggBold((String)"</b>"));
        Assertions.assertEquals((Object)"&lt;/B&gt;", (Object)EscapeUtils.escapeSpecialChars((String)"</B>"));
        Assertions.assertEquals((Object)"</B>", (Object)EscapeUtils.escapeSpecialCharsLeavinggBold((String)"</B>"));
    }

    @Test
    public void testEscapeLabelEmpty() {
        Assertions.assertEquals((Object)"", (Object)ViewUtilities.escapeForLabel((String)""));
    }

    @Test
    public void testEscapeLabelNonEmpty() {
        Assertions.assertEquals((Object)"abc", (Object)ViewUtilities.escapeForLabel((String)"abc"));
    }

    @Test
    public void testEscapeLabelWithAmpersand() {
        Assertions.assertEquals((Object)"ab&&c", (Object)ViewUtilities.escapeForLabel((String)"ab&c"));
    }

    @Test
    public void testEscapeLabelMultipleAmpersand() {
        Assertions.assertEquals((Object)"a&&b&&cd&&e", (Object)ViewUtilities.escapeForLabel((String)"a&b&cd&e"));
    }
}

