/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.other;

import org.assertj.core.api.Assertions;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.base.HelpEvaluationContext;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.ua.tests.help.other.UserToc;
import org.eclipse.ua.tests.help.other.UserTopic;
import org.junit.jupiter.api.Test;

public class TocObjectTest {
    private static final String TITLE_1 = "Toc Title";
    private static final String TOPIC_LABEL_1 = "Topic Label1";
    private static final String TOPIC_LABEL_2 = "Topic Label2";
    private static final String TOPIC_LABEL_3 = "Topic Label3";
    private static final String ANCHOR1 = "#A1";
    private static final String ANCHOR2 = "#A2";
    private static final String PATH = "/org.eclipse.ua.tests/file.html";

    @Test
    public void testLookupUnanchoredHref() {
        UserToc utoc = new UserToc(TITLE_1, null, true);
        UserTopic utopic = new UserTopic(TOPIC_LABEL_1, PATH, true);
        utoc.addTopic(utopic);
        Toc toc = new Toc((IToc)utoc);
        ITopic topic = toc.getTopic(PATH);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic);
        org.junit.jupiter.api.Assertions.assertEquals((Object)topic.getHref(), (Object)PATH);
    }

    @Test
    public void testLookupAnchoredHrefByAnchor() {
        UserToc utoc = new UserToc(TITLE_1, null, true);
        UserTopic utopic = new UserTopic(TOPIC_LABEL_1, "/org.eclipse.ua.tests/file.html#A1", true);
        utoc.addTopic(utopic);
        Toc toc = new Toc((IToc)utoc);
        ITopic topic = toc.getTopic("/org.eclipse.ua.tests/file.html#A1");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic);
        org.junit.jupiter.api.Assertions.assertEquals((Object)topic.getHref(), (Object)"/org.eclipse.ua.tests/file.html#A1");
    }

    @Test
    public void testLookupAnchoredHref() {
        UserToc utoc = new UserToc(TITLE_1, null, true);
        UserTopic utopic = new UserTopic(TOPIC_LABEL_1, "/org.eclipse.ua.tests/file.html#A1", true);
        utoc.addTopic(utopic);
        Toc toc = new Toc((IToc)utoc);
        ITopic topic = toc.getTopic(PATH);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic);
        org.junit.jupiter.api.Assertions.assertEquals((Object)topic.getLabel(), (Object)TOPIC_LABEL_1);
    }

    @Test
    public void testUnanchoredFoundFirst() {
        UserToc utoc = new UserToc(TITLE_1, null, true);
        UserTopic utopic = new UserTopic(TOPIC_LABEL_1, "/org.eclipse.ua.tests/file.html#A1", true);
        utoc.addTopic(utopic);
        utopic = new UserTopic(TOPIC_LABEL_2, PATH, true);
        utoc.addTopic(utopic);
        utopic = new UserTopic(TOPIC_LABEL_3, "/org.eclipse.ua.tests/file.html#A2", true);
        utoc.addTopic(utopic);
        Toc toc = new Toc((IToc)utoc);
        ITopic topic = toc.getTopic(PATH);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic);
        org.junit.jupiter.api.Assertions.assertEquals((Object)topic.getLabel(), (Object)TOPIC_LABEL_2);
    }

    @Test
    public void testGetTopicNull() {
        UserToc utoc = new UserToc(TITLE_1, null, true);
        Toc toc = new Toc((IToc)utoc);
        ITopic emptyTopic = toc.getTopic(null);
        Assertions.assertThat((Object[])emptyTopic.getChildren()).isEmpty();
        Assertions.assertThat((Object)emptyTopic).matches(it -> it.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()), "is enabed");
    }
}

