/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.other;

import org.assertj.core.api.Assertions;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.Topic;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpEvaluationContext;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.eclipse.ua.tests.help.other.UserTopic;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TopicTest {
    private static final String ECLIPSE_HREF = "http://www.eclipse.org";
    private static final String ECLIPSE = "eclipse";
    private static final String BUGZILLA = "bugzilla";
    private static final String BUGZILLA_HREF = "https://bugs.eclipse.org/bugs/";
    private static final String INVALID_INSTALLED = "<with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with>";
    private static final String CS_INSTALLED = "<with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with>";
    private static final String ENABLEMENT_CHEATSHEETS = "<enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement>";
    private static final String ENABLEMENT_INVALID = "<enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement>";
    private static final String FILTER_IN = "<filter name = \"plugin\" value = \"org.eclipse.ua.tests\"/>";
    private static final String FILTER_OUT = "<filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/>";
    private static final String NEGATED_FILTER_IN = "<filter name = \"plugin\" value = \"!org.eclipse.ua.tests\"/>";
    private static final String NEGATED_FILTER_OUT = "<filter name = \"plugin\" value = \"!org.eclipse.ua.invalid\"/>";
    private static final String TOPIC_END = "</topic>";
    private static final String TOPIC_HEAD_ECLIPSE = "<topic href=\"http://www.eclipse.org\" label=\"eclipse\">";
    private static final String TOPIC_ECLIPSE = "<topic href=\"http://www.eclipse.org\" label=\"eclipse\"/>";
    private static final String TOPIC_BUGZILLA = "<topic href=\"https://bugs.eclipse.org/bugs/\" label=\"bugzilla\"/>";
    private final String TOPIC_WITH_ENABLEMENT = "<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic>";
    private final String TOPIC_NOT_ENABLED = "<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement></topic>";
    private final String TOPIC_FILTER_IN = "<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><filter name = \"plugin\" value = \"org.eclipse.ua.tests\"/></topic>";
    private final String TOPIC_FILTER_OUT = "<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/></topic>";
    private final String TOPIC_FILTER_MIXED = "<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><filter name = \"plugin\" value = \"org.eclipse.ua.tests\"/><filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/></topic>";
    private static final String TOPIC_OLD_FILTER = "<topic filter=\"plugin=org.eclipse.ua.tests\" href=\"www.eclipse.org\" label=\"Transformations and transformation configurations\"/>";
    private static final String TOPIC_OLD_FILTER_DISABLED = "<topic filter=\"plugin=org.eclipse.ua.invalid\" href=\"www.eclipse.org\" label=\"Transformations and transformation configurations\"/>";
    private static final String TOPIC_OLD_FILTER_IN__NEGATED = "<topic filter=\"plugin!=org.eclipse.ua.tests\" href=\"www.eclipse.org\" label=\"Transformations and transformation configurations\"/>";
    private static final String TOPIC_OLD_FILTER_OUT_NEGATED = "<topic filter=\"plugin!=org.eclipse.ua.invalid\" href=\"www.eclipse.org\" label=\"Transformations and transformation configurations\"/>";
    private final String TOPIC_WITH_CHILD = "<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><topic href=\"https://bugs.eclipse.org/bugs/\" label=\"bugzilla\"/></topic>";
    private int mode;

    @BeforeEach
    public void setUp() throws Exception {
        this.mode = BaseHelpSystem.getMode();
        BaseHelpSystem.setMode((int)0);
    }

    @AfterEach
    public void tearDown() {
        BaseHelpSystem.setMode((int)this.mode);
    }

    private Topic createTopic(String topicSource) {
        Document doc;
        try {
            doc = LocalEntityResolver.parse((String)topicSource);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"Caught Exception");
            doc = null;
        }
        Topic topic = new Topic((Element)doc.getFirstChild());
        return topic;
    }

    @Test
    public void testSimpleTopic() {
        Topic topic = this.createTopic(TOPIC_ECLIPSE);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)topic.getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE_HREF, (Object)topic.getHref());
    }

    @Test
    public void testCopySimpleTopic() {
        Topic topic1 = this.createTopic(TOPIC_ECLIPSE);
        Topic topic2 = new Topic((ITopic)topic1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)topic1.getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE_HREF, (Object)topic1.getHref());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)topic2.getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE_HREF, (Object)topic2.getHref());
    }

    @Test
    public void testCopyTopicWithChild() {
        Topic topic1 = this.createTopic("<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><topic href=\"https://bugs.eclipse.org/bugs/\" label=\"bugzilla\"/></topic>");
        Topic topic2 = new Topic((ITopic)topic1);
        Assertions.assertThat((Object[])topic1.getSubtopics()).hasSize(1);
        Topic child1 = (Topic)topic1.getSubtopics()[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA, (Object)child1.getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA_HREF, (Object)child1.getHref());
        Assertions.assertThat((Object[])topic2.getSubtopics()).hasSize(1);
        Topic child2 = (Topic)topic2.getSubtopics()[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA, (Object)child2.getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA_HREF, (Object)child2.getHref());
        Assertions.assertThat((Object[])topic2.getSubtopics()).hasSize(1);
    }

    @Test
    public void testEnabledTopic() {
        Topic topic = this.createTopic("<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></enablement></topic>");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)topic.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testDisabledTopic() {
        Topic topic = this.createTopic("<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement></topic>");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topic.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testCopyDisabledTopic() {
        Topic topic1 = this.createTopic("<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement></topic>");
        Topic topic2 = new Topic((ITopic)topic1);
        Topic topic3 = new Topic((ITopic)topic2);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topic1.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topic2.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topic3.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testCompoundEnablement() {
        Topic topic = this.createTopic("<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><enablement><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with></enablement></topic>");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topic.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        topic = this.createTopic("<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><enablement><and><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.invalid\"/></with><with variable=\"platform\"><test property=\"org.eclipse.core.runtime.isBundleInstalled\" args=\"org.eclipse.ui.cheatsheets\"/></with></and></enablement></topic>");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topic.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testOldStyleEnablement() {
        Topic topic = this.createTopic(TOPIC_OLD_FILTER);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)topic.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testOldStyleDisabled() {
        Topic topic = this.createTopic(TOPIC_OLD_FILTER_DISABLED);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topic.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testOldStyleNegated() {
        Topic topic = this.createTopic(TOPIC_OLD_FILTER_IN__NEGATED);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topic.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        topic = this.createTopic(TOPIC_OLD_FILTER_OUT_NEGATED);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)topic.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testCopyOldStyleDisabled() {
        Topic topic1 = this.createTopic(TOPIC_OLD_FILTER_DISABLED);
        Topic topic2 = new Topic((ITopic)topic1);
        Topic topic3 = new Topic((ITopic)topic2);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topic1.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topic2.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topic3.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testFilterIn() {
        Topic topic = this.createTopic("<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><filter name = \"plugin\" value = \"org.eclipse.ua.tests\"/></topic>");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)topic.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testFilterOut() {
        Topic topic = this.createTopic("<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/></topic>");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topic.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testFilterMixed() {
        Topic topic = this.createTopic("<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><filter name = \"plugin\" value = \"org.eclipse.ua.tests\"/><filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/></topic>");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topic.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testNegatedFilters() {
        Topic topic = this.createTopic("<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><filter name = \"plugin\" value = \"!org.eclipse.ua.tests\"/></topic>");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topic.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        topic = this.createTopic("<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><filter name = \"plugin\" value = \"!org.eclipse.ua.invalid\"/></topic>");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)topic.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testCopyFilterOut() {
        Topic topic1 = this.createTopic("<topic href=\"http://www.eclipse.org\" label=\"eclipse\"><filter name = \"plugin\" value = \"org.eclipse.ua.invalid\"/></topic>");
        Topic topic2 = new Topic((ITopic)topic1);
        Topic topic3 = new Topic((ITopic)topic2);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topic1.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topic2.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)topic3.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testUserTopic() {
        UserTopic u1 = new UserTopic(ECLIPSE, ECLIPSE_HREF, false);
        Topic t1 = new Topic((ITopic)u1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)t1.getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE_HREF, (Object)t1.getHref());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)t1.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testCopyFilteredUserTopic() {
        UserTopic u1 = new UserTopic(ECLIPSE, ECLIPSE_HREF, false);
        Topic t1 = new Topic((ITopic)u1);
        Topic t2 = new Topic((ITopic)t1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)t1.getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE_HREF, (Object)t1.getHref());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)t1.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)t2.getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE_HREF, (Object)t2.getHref());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)t2.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testUserTopicWithFilteredChildren() {
        UserTopic u1 = new UserTopic(ECLIPSE, ECLIPSE_HREF, true);
        UserTopic u2 = new UserTopic(BUGZILLA, BUGZILLA_HREF, false);
        u1.addTopic(u2);
        Topic t1 = new Topic((ITopic)u1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)t1.getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE_HREF, (Object)t1.getHref());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)t1.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        Assertions.assertThat((Object[])t1.getChildren()).hasSize(1);
        ITopic t2 = t1.getSubtopics()[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA, (Object)t2.getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA_HREF, (Object)t2.getHref());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)t2.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
    }

    @Test
    public void testCopyUserTopicWithChildren() {
        UserTopic u1 = new UserTopic(ECLIPSE, ECLIPSE_HREF, true);
        UserTopic u2 = new UserTopic(BUGZILLA, BUGZILLA_HREF, true);
        u1.addTopic(u2);
        Topic t1 = new Topic((ITopic)u1);
        Topic t2 = new Topic((ITopic)t1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)t1.getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE_HREF, (Object)t1.getHref());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)t1.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        Assertions.assertThat((Object[])t1.getChildren()).hasSize(1);
        ITopic t1s = t1.getSubtopics()[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA, (Object)t1s.getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA_HREF, (Object)t1s.getHref());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)t2.getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE_HREF, (Object)t2.getHref());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)t2.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext()));
        Assertions.assertThat((Object[])t2.getChildren()).hasSize(1);
        ITopic t2s = t2.getSubtopics()[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA, (Object)t2s.getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA_HREF, (Object)t2s.getHref());
    }
}

