/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.other;

import org.assertj.core.api.Assertions;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.Topic;
import org.eclipse.help.internal.UAElement;
import org.junit.jupiter.api.Test;

public class UAElementTest {
    private UAElement parent1;
    private UAElement parent2;
    private UAElement child1;
    private UAElement child2;
    private UAElement child3;
    private UAElement child4;
    private UAElement grandchild1;

    @Test
    public void testSimpleUAElement() {
        UAElement element = new UAElement("name1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"name1", (Object)element.getElementName());
        Assertions.assertThat((Object[])element.getChildren()).isEmpty();
        Object[] topicChildren = element.getChildren(Topic.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(topicChildren instanceof Topic[]));
        Assertions.assertThat((Object[])((Topic[])topicChildren)).isEmpty();
        org.junit.jupiter.api.Assertions.assertNull((Object)element.getParentElement());
        org.junit.jupiter.api.Assertions.assertNull((Object)element.getAttribute("a1"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)element.equals(element));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)element.equals(null));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)element.equals("A string"));
    }

    @Test
    public void testAttributes() {
        UAElement element = new UAElement("name1");
        element.setAttribute("a1", "v1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"v1", (Object)element.getAttribute("a1"));
        org.junit.jupiter.api.Assertions.assertNull((Object)element.getAttribute("a2"));
        org.junit.jupiter.api.Assertions.assertNull((Object)element.getAttribute("A1"));
        element.setAttribute("a1", "v2");
        element.setAttribute("a2", "v1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"v2", (Object)element.getAttribute("a1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"v1", (Object)element.getAttribute("a2"));
        element.setAttribute("a1", null);
        org.junit.jupiter.api.Assertions.assertNull((Object)element.getAttribute("a1"));
    }

    @Test
    public void testChildInsertionDeletion() {
        this.initializeElements();
        this.parent1.appendChild(this.child1);
        Object[] children = this.parent1.getChildren();
        Assertions.assertThat((Object[])children).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"c1", (Object)((UAElement)children[0]).getElementName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.parent1, (Object)((UAElement)children[0]).getParentElement());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"c1", (Object)((UAElement)children[0]).getAttribute("id"));
        this.parent1.appendChild(this.child2);
        children = this.parent1.getChildren();
        Assertions.assertThat((Object[])children).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"c2", (Object)((UAElement)children[1]).getElementName());
        this.parent1.insertBefore(this.child3, this.child2);
        children = this.parent1.getChildren();
        Assertions.assertThat((Object[])children).hasSize(3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"c3", (Object)((UAElement)children[1]).getElementName());
        this.parent1.removeChild(this.child1);
        children = this.parent1.getChildren();
        Assertions.assertThat((Object[])children).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"c3", (Object)((UAElement)children[0]).getElementName());
        this.parent1.appendChildren(new IUAElement[]{this.child1, this.child4});
        children = this.parent1.getChildren();
        Assertions.assertThat((Object[])children).hasSize(4);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"c1", (Object)((UAElement)children[2]).getElementName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"c4", (Object)((UAElement)children[3]).getElementName());
    }

    @Test
    public void testDuplicateChildren() {
        this.initializeElements();
        this.parent1.appendChild(this.child1);
        this.parent1.appendChild(this.child2);
        this.parent1.appendChild(this.child2);
        this.parent1.appendChild(this.child1);
        Object[] children = this.parent1.getChildren();
        Assertions.assertThat((Object[])children).hasSize(4);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"c1", (Object)((UAElement)children[0]).getElementName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"c2", (Object)((UAElement)children[1]).getElementName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"c2", (Object)((UAElement)children[2]).getElementName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"c1", (Object)((UAElement)children[3]).getElementName());
    }

    @Test
    public void testGrandchildren() {
        this.initializeElements();
        this.child1.appendChild(this.grandchild1);
        this.parent2.appendChild(this.child1);
        UAElement firstChild = (UAElement)this.parent2.getChildren()[0];
        Assertions.assertThat((Object[])firstChild.getChildren()).hasSize(1);
        UAElement firstGrandchild = (UAElement)firstChild.getChildren()[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)"g1", (Object)firstGrandchild.getElementName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)firstGrandchild.getParentElement(), (Object)firstChild);
    }

    @Test
    public void testMultipleParents() {
        this.initializeElements();
        this.child1.appendChild(this.grandchild1);
        this.parent1.appendChild(this.child1);
        this.parent2.appendChild(this.child1);
        UAElement firstChild1 = (UAElement)this.parent1.getChildren()[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)firstChild1.getParentElement(), (Object)this.parent1);
        UAElement firstChild2 = (UAElement)this.parent2.getChildren()[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)firstChild2.getParentElement(), (Object)this.parent2);
    }

    @Test
    public void testMultipleGrandParents() {
        this.initializeElements();
        this.child1.appendChild(this.grandchild1);
        this.parent1.appendChild(this.child1);
        this.parent2.appendChild(this.child1);
        UAElement firstChild1 = (UAElement)this.parent1.getChildren()[0];
        UAElement firstGrandchild1 = (UAElement)firstChild1.getChildren()[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)firstGrandchild1.getParentElement(), (Object)firstChild1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)firstChild1.getParentElement(), (Object)this.parent1);
        UAElement firstChild2 = (UAElement)this.parent2.getChildren()[0];
        UAElement firstGrandchild2 = (UAElement)firstChild2.getChildren()[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)firstGrandchild2.getParentElement(), (Object)firstChild2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)firstChild2.getParentElement(), (Object)this.parent2);
    }

    private void initializeElements() {
        this.parent1 = new UAElement("p1");
        this.parent2 = new UAElement("p2");
        this.child1 = new UAElement("c1");
        this.child1.setAttribute("id", "c1");
        this.child2 = new UAElement("c2");
        this.child2.setAttribute("id", "c2");
        this.child3 = new UAElement("c3");
        this.child3.setAttribute("id", "c3");
        this.child4 = new UAElement("c4");
        this.grandchild1 = new UAElement("g1");
        this.grandchild1.setAttribute("id", "g1");
    }
}

