/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.other;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IIndexEntry2;
import org.eclipse.help.IIndexSee;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;

public class UserIndexEntry
implements IIndexEntry2 {
    private final List<IIndexEntry> subentries = new ArrayList<IIndexEntry>();
    private final List<IIndexSee> sees = new ArrayList<IIndexSee>();
    private final List<ITopic> topics = new ArrayList<ITopic>();
    private final boolean isEnabled;
    private final String keyword;

    public IUAElement[] getChildren() {
        IIndexEntry[] subentries = this.getSubentries();
        IIndexSee[] sees = this.getSees();
        ITopic[] topics = this.getTopics();
        IUAElement[] result = new IUAElement[subentries.length + sees.length + topics.length];
        System.arraycopy(topics, 0, result, 0, topics.length);
        System.arraycopy(subentries, 0, result, topics.length, subentries.length);
        System.arraycopy(sees, 0, result, topics.length + subentries.length, sees.length);
        return result;
    }

    public boolean isEnabled(IEvaluationContext context) {
        return this.isEnabled;
    }

    public void addSee(IIndexSee child) {
        this.sees.add(child);
    }

    public void addEntry(IIndexEntry child) {
        this.subentries.add(child);
    }

    public void addTopic(ITopic child) {
        this.topics.add(child);
    }

    public UserIndexEntry(String keyword, boolean isEnabled) {
        this.keyword = keyword;
        this.isEnabled = isEnabled;
    }

    public IIndexSee[] getSees() {
        return this.sees.toArray(new IIndexSee[0]);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public IIndexEntry[] getSubentries() {
        return this.subentries.toArray(new IIndexEntry[0]);
    }

    public ITopic[] getTopics() {
        return this.topics.toArray(new ITopic[0]);
    }
}

