/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.other;

import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XHTMLEntityTest {
    private static final String XHTML1 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\n<head></head><body>";
    private static final String XHTML2 = "</body></html>";

    public void checkResolution(String text, int expected) throws Exception {
        String xmlSource = XHTML1 + text + XHTML2;
        Document doc = LocalEntityResolver.parse((String)xmlSource);
        Assertions.assertEquals((int)2, (int)doc.getChildNodes().getLength());
        Node bodyNode = doc.getElementsByTagName("body").item(0);
        Node textNode = bodyNode.getChildNodes().item(0);
        Assertions.assertNotNull((Object)textNode);
        String value = textNode.getNodeValue();
        Assertions.assertEquals((int)1, (int)value.length());
        Assertions.assertEquals((int)expected, (int)value.charAt(0));
    }

    @Test
    public void testResolveAmpersand() throws Exception {
        this.checkResolution("&amp;", 38);
    }

    @Test
    public void testResolveNonBlockingSpace() throws Exception {
        this.checkResolution("&nbsp;", 160);
    }

    @Test
    public void testResolveGt() throws Exception {
        this.checkResolution("&gt;", 62);
    }

    @Test
    public void testResolveLeftArrow() throws Exception {
        this.checkResolution("&larr;", 8592);
    }

    @Test
    public void testResolveaacute() throws Exception {
        this.checkResolution("&aacute;", 225);
    }

    @Test
    public void testResolveCopy() throws Exception {
        this.checkResolution("&copy;", 169);
    }

    @Test
    public void testResolveTilde() throws Exception {
        this.checkResolution("&tilde;", 732);
    }

    @Test
    public void testResolveAacute() throws Exception {
        this.checkResolution("&Aacute;", 193);
    }

    @Test
    public void testResolveAlpha() throws Exception {
        this.checkResolution("&Alpha;", 913);
    }
}

