/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.performance;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.AbstractIndexProvider;
import org.eclipse.help.AbstractTocProvider;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.index.IndexManager;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.SearchIndex;
import org.eclipse.help.internal.search.SearchIndexWithIndexingProgress;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocFileProvider;
import org.eclipse.help.internal.toc.TocManager;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceTestCaseJunit5;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.osgi.framework.FrameworkUtil;

public class BuildHtmlSearchIndex
extends PerformanceTestCaseJunit5 {
    private AbstractTocProvider[] tocProviders;
    private AbstractIndexProvider[] indexProviders;
    private AnalyzerDescriptor analyzerDesc;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        super.setUp(testInfo);
        TocManager tocManager = HelpPlugin.getTocManager();
        this.tocProviders = tocManager.getTocProviders();
        tocManager.setTocProviders(new AbstractTocProvider[]{new TestTocFileProvider()});
        tocManager.clearCache();
        IndexManager indexManager = HelpPlugin.getIndexManager();
        this.indexProviders = indexManager.getIndexProviders();
        indexManager.setIndexProviders(new AbstractIndexProvider[0]);
        indexManager.clearCache();
        this.analyzerDesc = new AnalyzerDescriptor("en-us");
    }

    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        TocManager tocManager = HelpPlugin.getTocManager();
        tocManager.setTocProviders(this.tocProviders);
        tocManager.clearCache();
        IndexManager indexManager = HelpPlugin.getIndexManager();
        indexManager.setIndexProviders(this.indexProviders);
        indexManager.clearCache();
        this.analyzerDesc = null;
        this.tocProviders = null;
        this.indexProviders = null;
    }

    @Test
    public void testCreateHtmlSearchIndex() throws Exception {
        this.tagAsGlobalSummary("Create HTML Search Index", Dimension.ELAPSED_PROCESS);
        int i = 0;
        while (i < 3) {
            this.buildIndex();
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.startMeasuring();
            this.buildIndex();
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    private void buildIndex() {
        SearchIndexWithIndexingProgress index = new SearchIndexWithIndexingProgress("en-us", this.analyzerDesc, HelpPlugin.getTocManager());
        index.beginAddBatch(true);
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/search/test7.html");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/search/test8.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/search/test9.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_content_active_action.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_content.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_content_active.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_content_active_action.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_content_active_debug.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_content_active_invoke.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_content_command.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_content_command_authoring.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_content_files.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_content_manifest.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_content_nested.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_content_process.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_content_remote.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_content_toc.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_content_xhtml.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_context.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_context_dynamic.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_context_id.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_context_infopops.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_context_xml.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_menu.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_search.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_search_types.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_setup.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_setup_about.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_setup_help_data.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_setup_infocenter.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_setup_nav.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_setup_preferences.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_setup_preindex.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_setup_rcp.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_setup_standalone.htm");
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/performance/search/ua_help_war.htm");
        index.endAddBatch(true, true);
        index.close();
    }

    private void addHrefToIndex(SearchIndexWithIndexingProgress index, String doc) {
        URL url = SearchIndex.getIndexableURL((String)index.getLocale(), (String)doc);
        IStatus status = index.addDocument(url.getFile(), url);
        Assertions.assertTrue((boolean)status.isOK());
    }

    private static class TestTocFileProvider
    extends TocFileProvider {
        private TestTocFileProvider() {
        }

        protected TocFile[] getTocFiles(String locale) {
            String id = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName();
            String nl = Platform.getNL();
            return new TocFile[]{new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.isv/toc.xml", true, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.isv/topics_Guide.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.isv/topics_Porting.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.isv/topics_Questions.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.isv/topics_Reference.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.isv/topics_Samples.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.user/toc.xml", true, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.user/topics_Concepts.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.user/topics_GettingStarted.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.user/topics_Reference.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.user/topics_Tasks.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.pde.doc.user/toc.xml", true, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.pde.doc.user/topics_Reference.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.isv/toc.xml", true, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.isv/topics_Guide.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.isv/topics_Porting.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.isv/topics_Questions.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.isv/topics_Reference.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.isv/topics_Samples.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.user/toc.xml", true, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.user/topics_Concepts.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.user/topics_GettingStarted.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.user/topics_Reference.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.user/topics_Tasks.xml", false, nl, null, null)};
        }
    }
}

