/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.performance;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.index.Index;
import org.eclipse.help.internal.index.IndexAssembler;
import org.eclipse.help.internal.index.IndexContribution;
import org.eclipse.help.internal.index.IndexFile;
import org.eclipse.help.internal.index.IndexFileParser;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceTestCaseJunit5;
import org.junit.jupiter.api.Test;
import org.osgi.framework.FrameworkUtil;
import org.xml.sax.SAXException;

public class IndexAssemblePerformanceTest
extends PerformanceTestCaseJunit5 {
    @Test
    public void testIndexAssemble() throws Exception {
        this.tagAsSummary("Assemble Index", Dimension.ELAPSED_PROCESS);
        int i = 0;
        while (i < 10) {
            boolean warmup;
            boolean bl = warmup = i == 0;
            if (!warmup) {
                this.startMeasuring();
            }
            this.assembleIndex();
            if (!warmup) {
                this.stopMeasuring();
            }
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    private void assembleIndex() throws IOException, SAXException, ParserConfigurationException {
        IndexFileParser parser = new IndexFileParser();
        String bsn = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName();
        IndexContribution a = parser.parse(new IndexFile(bsn, "data/help/performance/index/index1.xml", "en"));
        IndexContribution b = parser.parse(new IndexFile(bsn, "data/help/performance/index/index2.xml", "en"));
        IndexContribution c = parser.parse(new IndexFile(bsn, "data/help/performance/index/index3.xml", "en"));
        IndexAssembler assembler = new IndexAssembler();
        ArrayList<IndexContribution> contributions = new ArrayList<IndexContribution>(Arrays.asList(a, b, c));
        Index assembled = assembler.assemble(contributions, Platform.getNL());
        Assertions.assertThat((Object[])assembled.getChildren()).hasSize(100);
    }
}

