/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.performance;

import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceTestCaseJunit5;
import org.eclipse.ua.tests.help.util.LoadServletUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class LowIterationHelpServerTest
extends PerformanceTestCaseJunit5 {
    @AfterEach
    public void tearDown() throws Exception {
        LoadServletUtil.stopServer();
        super.tearDown();
    }

    @Test
    public void testServletRead20x() throws Exception {
        this.tagAsSummary("Servlet Read", Dimension.ELAPSED_PROCESS);
        LoadServletUtil.startServer();
        int i = 0;
        while (i < 15) {
            boolean warmup;
            boolean bl = warmup = i < 2;
            if (!warmup) {
                this.startMeasuring();
            }
            int j = 0;
            while (j <= 20) {
                LoadServletUtil.readLoadServlet(200);
                ++j;
            }
            if (!warmup) {
                this.stopMeasuring();
            }
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    @Test
    public void testStartServer() throws Exception {
        this.tagAsSummary("Start Server", Dimension.ELAPSED_PROCESS);
        int i = 0;
        while (i < 25) {
            boolean warmup = i < 2;
            LoadServletUtil.stopServer();
            if (!warmup) {
                this.startMeasuring();
            }
            LoadServletUtil.startServer();
            if (!warmup) {
                this.stopMeasuring();
            }
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }
}

