/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.performance;

import org.eclipse.core.runtime.Platform;
import org.eclipse.help.AbstractIndexProvider;
import org.eclipse.help.AbstractTocProvider;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.index.IndexManager;
import org.eclipse.help.internal.server.WebappManager;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocFileProvider;
import org.eclipse.help.internal.toc.TocManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceTestCaseJunit5;
import org.eclipse.ui.PlatformUI;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.osgi.framework.FrameworkUtil;

@Disabled(value="Disabled due to inability to get reliable results. Browser/SWT changes in timing of listener events no longer consistent in 3.3.")
public class OpenHelpTest
extends PerformanceTestCaseJunit5 {
    private AbstractTocProvider[] tocProviders;
    private AbstractIndexProvider[] indexProviders;
    private Shell shell;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        super.setUp(testInfo);
        TocManager tocManager = HelpPlugin.getTocManager();
        this.tocProviders = tocManager.getTocProviders();
        tocManager.setTocProviders(new AbstractTocProvider[]{new TestTocFileProvider()});
        tocManager.clearCache();
        IndexManager indexManager = HelpPlugin.getIndexManager();
        this.indexProviders = indexManager.getIndexProviders();
        indexManager.setIndexProviders(new AbstractIndexProvider[0]);
        indexManager.clearCache();
    }

    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        TocManager tocManager = HelpPlugin.getTocManager();
        tocManager.setTocProviders(this.tocProviders);
        tocManager.clearCache();
        IndexManager indexManager = HelpPlugin.getIndexManager();
        indexManager.setIndexProviders(this.indexProviders);
        indexManager.clearCache();
    }

    @Test
    public void testOpenHelp() throws Exception {
        this.tagAsGlobalSummary("Open help", Dimension.ELAPSED_PROCESS);
        int i = 0;
        while (i < 3) {
            this.openHelp();
            this.closeHelp();
            ++i;
        }
        i = 0;
        while (i < 50) {
            this.startMeasuring();
            this.openHelp();
            this.stopMeasuring();
            this.closeHelp();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    private void openHelp() throws Exception {
        BaseHelpSystem.ensureWebappRunning();
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        this.shell = new Shell(parent);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setSize(parent.getSize());
        Browser browser = new Browser((Composite)this.shell, 0);
        this.shell.open();
        final boolean[] done = new boolean[1];
        final String url = "http://" + WebappManager.getHost() + ":" + WebappManager.getPort() + "/help/index.jsp";
        browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changed(LocationEvent event) {
                if (url.equals(event.location)) {
                    done[0] = true;
                }
            }
        });
        browser.setUrl(url);
        Display display = Display.getDefault();
        while (!done[0]) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        OpenHelpTest.flush();
    }

    private void closeHelp() throws Exception {
        if (this.shell != null) {
            this.shell.dispose();
            this.shell = null;
        }
    }

    private static void flush() {
        Display display = Display.getCurrent();
        while (display.readAndDispatch()) {
        }
    }

    private static class TestTocFileProvider
    extends TocFileProvider {
        private TestTocFileProvider() {
        }

        protected TocFile[] getTocFiles(String locale) {
            String id = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName();
            String nl = Platform.getNL();
            return new TocFile[]{new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.isv/toc.xml", true, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.isv/topics_Guide.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.isv/topics_Porting.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.isv/topics_Questions.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.isv/topics_Reference.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.isv/topics_Samples.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.user/toc.xml", true, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.user/topics_Concepts.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.user/topics_GettingStarted.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.user/topics_Reference.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.jdt.doc.user/topics_Tasks.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.pde.doc.user/toc.xml", true, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.pde.doc.user/topics_Reference.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.isv/toc.xml", true, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.isv/topics_Guide.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.isv/topics_Porting.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.isv/topics_Questions.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.isv/topics_Reference.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.isv/topics_Samples.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.user/toc.xml", true, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.user/topics_Concepts.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.user/topics_GettingStarted.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.user/topics_Reference.xml", false, nl, null, null), new TocFile(id, "data/help/performance/org.eclipse.platform.doc.user/topics_Tasks.xml", false, nl, null, null)};
        }
    }
}

