/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.performance;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.toc.TocAssembler;
import org.eclipse.help.internal.toc.TocContribution;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocFileParser;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceTestCaseJunit5;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.osgi.framework.FrameworkUtil;
import org.xml.sax.SAXException;

public class TocAssemblePerformanceTest
extends PerformanceTestCaseJunit5 {
    private TocContribution parse(TocFileParser parser, String tocFile) throws IOException, SAXException, ParserConfigurationException {
        return parser.parse(new TocFile(FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName(), tocFile, true, "en", null, null));
    }

    public void assembleToc() throws Exception {
        TocFileParser parser = new TocFileParser();
        List contributions = new ArrayList<TocContribution>();
        contributions.add(this.parse(parser, "data/help/performance/org.eclipse.jdt.doc.isv/jdttoc.xml"));
        contributions.add(this.parse(parser, "data/help/performance/org.eclipse.jdt.doc.isv/topics_Guide.xml"));
        contributions.add(this.parse(parser, "data/help/performance/org.eclipse.jdt.doc.isv/topics_Porting.xml"));
        contributions.add(this.parse(parser, "data/help/performance/org.eclipse.jdt.doc.isv/topics_Questions.xml"));
        contributions.add(this.parse(parser, "data/help/performance/org.eclipse.jdt.doc.isv/topics_Reference.xml"));
        contributions.add(this.parse(parser, "data/help/performance/org.eclipse.jdt.doc.isv/topics_Samples.xml"));
        contributions.add(this.parse(parser, "data/help/performance/org.eclipse.jdt.doc.isv/topics_Samples.xml"));
        TocAssembler assembler = new TocAssembler();
        contributions = assembler.assemble(contributions);
        Assertions.assertEquals((int)1, (int)contributions.size());
        TocContribution toc = (TocContribution)contributions.get(0);
        Assertions.assertEquals((int)101, (int)this.countTopics(toc.getToc().getTopics()));
    }

    private int countTopics(ITopic[] topics) {
        int result = topics.length;
        ITopic[] iTopicArray = topics;
        int n = topics.length;
        int n2 = 0;
        while (n2 < n) {
            ITopic topic = iTopicArray[n2];
            result += this.countTopics(topic.getSubtopics());
            ++n2;
        }
        return result;
    }

    @Test
    public void testTocAssemble() throws Exception {
        this.tagAsSummary("Assemble TOC", Dimension.ELAPSED_PROCESS);
        int i = 0;
        while (i < 100) {
            boolean warmup;
            boolean bl = warmup = i < 2;
            if (!warmup) {
                this.startMeasuring();
            }
            int j = 0;
            while (j < 20) {
                this.assembleToc();
                ++j;
            }
            if (!warmup) {
                this.stopMeasuring();
            }
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }
}

