/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.preferences;

import java.util.Observable;
import java.util.Observer;
import org.assertj.core.api.Assertions;
import org.eclipse.help.internal.base.BookmarkManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BookmarksTest {
    private static final String ECLIPSE = "eclipse";
    private static final String HTTP_ECLIPSE = "http://www.eclipse.org";
    private static final String HELP = "help";
    private static final String HTTP_HELP = "http://help.eclipse.org";
    private static final String BUGZILLA = "bugzilla";
    private static final String HTTP_BUGZILLA = "https://bugs.eclipse.org/bugs/";
    private BookmarkManager manager;
    private BookmarkObserver observer;

    @BeforeEach
    public void setUp() throws Exception {
        this.manager = new BookmarkManager();
        this.manager.removeAllBookmarks();
        this.observer = new BookmarkObserver();
        this.manager.addObserver((Observer)this.observer);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.manager = null;
        this.observer = null;
    }

    @Test
    public void testRemoveAll() {
        this.manager.removeAllBookmarks();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.observer.eventCount);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.manager, (Object)this.observer.o);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.observer.getEvent().getType());
        org.junit.jupiter.api.Assertions.assertNull((Object)this.observer.getEvent().getBookmark());
        Object[] bookmarks = this.manager.getBookmarks();
        Assertions.assertThat((Object[])bookmarks).isEmpty();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.observer.eventCount);
    }

    @Test
    public void testAddBookmarks() {
        this.manager.addBookmark(HTTP_ECLIPSE, ECLIPSE);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.observer.eventCount);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(this.observer.arg instanceof BookmarkManager.BookmarkEvent));
        BookmarkManager.BookmarkEvent event = this.observer.getEvent();
        org.junit.jupiter.api.Assertions.assertEquals((int)event.getType(), (int)2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)event.getBookmark().getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HTTP_ECLIPSE, (Object)event.getBookmark().getHref());
        this.manager.addBookmark(HTTP_BUGZILLA, BUGZILLA);
        BookmarkManager manager2 = new BookmarkManager();
        Object[] bookmarks = manager2.getBookmarks();
        Assertions.assertThat((Object[])bookmarks).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)bookmarks[0].getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA, (Object)bookmarks[1].getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HTTP_ECLIPSE, (Object)bookmarks[0].getHref());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HTTP_BUGZILLA, (Object)bookmarks[1].getHref());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.observer.eventCount);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.manager, (Object)this.observer.o);
    }

    @Test
    public void testRemoveBookmarks() {
        this.manager.addBookmark(HTTP_ECLIPSE, ECLIPSE);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.observer.eventCount);
        this.manager.addBookmark(HTTP_BUGZILLA, BUGZILLA);
        this.manager.addBookmark(HTTP_HELP, HELP);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.observer.eventCount);
        this.manager.removeBookmark(HTTP_ECLIPSE, BUGZILLA);
        org.junit.jupiter.api.Assertions.assertEquals((int)this.observer.eventCount, (int)3);
        this.manager.removeBookmark(HTTP_ECLIPSE, ECLIPSE);
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.observer.eventCount);
        BookmarkManager.BookmarkEvent event = this.observer.getEvent();
        org.junit.jupiter.api.Assertions.assertEquals((int)event.getType(), (int)3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ECLIPSE, (Object)event.getBookmark().getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HTTP_ECLIPSE, (Object)event.getBookmark().getHref());
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.manager, (Object)this.observer.o);
        this.manager.removeBookmark(new BookmarkManager.Bookmark(BUGZILLA, HTTP_BUGZILLA));
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.observer.eventCount);
        event = this.observer.getEvent();
        org.junit.jupiter.api.Assertions.assertEquals((int)event.getType(), (int)3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)BUGZILLA, (Object)event.getBookmark().getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HTTP_BUGZILLA, (Object)event.getBookmark().getHref());
        Assertions.assertThat((Object[])this.manager.getBookmarks()).hasSize(1);
    }

    private static class BookmarkObserver
    implements Observer {
        public Object o;
        public Object arg;
        public int eventCount = 0;

        private BookmarkObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            ++this.eventCount;
            this.o = o;
            this.arg = arg;
        }

        public BookmarkManager.BookmarkEvent getEvent() {
            return (BookmarkManager.BookmarkEvent)this.arg;
        }
    }
}

