/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.preferences;

import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.webapp.data.CssUtil;
import org.junit.jupiter.api.Test;

public class CssPreferences {
    private static final String ORG_ECLIPSE_TEST = "org.eclipse.test/";
    private static final String FILE_CSS = "file.css";
    private static final String ORG_ECLIPSE_TEST_FILE_CSS = "org.eclipse.test/file.css";
    private static final String FILENAME_WITH_PARAM = "org.eclipse.test/${os}file.css";
    private static final String FILENAME_WITH_OS = "org.eclipse.test/" + Platform.getOS() + "file.css";

    @Test
    public void testNull() {
        Object[] options = CssUtil.getCssFilenames(null);
        Assertions.assertThat((Object[])options).isEmpty();
    }

    @Test
    public void testEmptyString() {
        Object[] options = CssUtil.getCssFilenames((String)"");
        Assertions.assertThat((Object[])options).isEmpty();
    }

    @Test
    public void testSingleString() {
        Object[] options = CssUtil.getCssFilenames((String)ORG_ECLIPSE_TEST_FILE_CSS);
        Assertions.assertThat((Object[])options).containsExactly((Object[])new String[]{ORG_ECLIPSE_TEST_FILE_CSS});
    }

    @Test
    public void testTwoStrings() {
        Object[] options = CssUtil.getCssFilenames((String)"org.eclipse.test/file.css , org.eclipse.test/${os}file.css");
        Assertions.assertThat((Object[])options).containsExactly((Object[])new String[]{ORG_ECLIPSE_TEST_FILE_CSS, FILENAME_WITH_OS});
    }
}

