/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.preferences;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.internal.HelpData;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.FrameworkUtil;

public class HelpDataTest {
    private static final String[][][] TEST_DATA = new String[][][]{{{"data/help/preferences/helpData1.xml"}, {"toc1", "category1", "toc2", "toc3"}, {"toc4", "category2"}, {"index1", "index2"}}, {{"data/help/preferences/helpData2.xml"}, new String[0], new String[0], new String[0]}, {{"data/help/preferences/helpData3.xml"}, new String[0], new String[0], new String[0]}};
    private String baseTocsPreference;
    private String ignoredTocsPreference;
    private String ignoredIndexesPreference;

    @BeforeEach
    public void setUp() throws Exception {
        this.baseTocsPreference = Platform.getPreferencesService().getString("org.eclipse.help", "baseTOCS", "", null);
        this.ignoredTocsPreference = Platform.getPreferencesService().getString("org.eclipse.help", "ignoredTOCS", "", null);
        this.ignoredIndexesPreference = Platform.getPreferencesService().getString("org.eclipse.help", "ignoredIndexes", "", null);
        this.setBaseTocs("");
        this.setIgnoredTocs("");
        this.setIgnoredIndexes("");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.setBaseTocs(this.baseTocsPreference);
        this.setIgnoredTocs(this.ignoredTocsPreference);
        this.setIgnoredIndexes(this.ignoredIndexesPreference);
    }

    private void setBaseTocs(String value) {
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("org.eclipse.help");
        pref.put("baseTOCS", value);
    }

    private void setIgnoredTocs(String value) {
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("org.eclipse.help");
        pref.put("ignoredTOCS", value);
    }

    private void setIgnoredIndexes(String value) {
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("org.eclipse.help");
        pref.put("ignoredIndexes", value);
    }

    @Test
    public void testHelpData() {
        String[][][] stringArray = TEST_DATA;
        int n = TEST_DATA.length;
        int n2 = 0;
        while (n2 < n) {
            String[][] entry = stringArray[n2];
            String file = entry[0][0];
            List<String> expectedTocOrder = Arrays.asList(entry[1]);
            HashSet<String> expectedHiddenTocs = new HashSet<String>(Arrays.asList(entry[2]));
            HashSet<String> expectedHiddenIndexes = new HashSet<String>(Arrays.asList(entry[3]));
            URL url = FrameworkUtil.getBundle(HelpDataTest.class).getEntry(file);
            HelpData data = new HelpData(url);
            ((ListAssert)Assertions.assertThat((List)data.getTocOrder()).as("toc order from help data file " + file, new Object[0])).containsExactlyElementsOf(expectedTocOrder);
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)data.getHiddenTocs()).as("hidden tocs from help data file " + file, new Object[0])).containsExactlyElementsOf(expectedHiddenTocs);
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)data.getHiddenIndexes()).as("hidden indexes from help data file " + file, new Object[0])).containsExactlyElementsOf(expectedHiddenIndexes);
            ++n2;
        }
    }

    @Test
    public void testNullUrl() {
        HelpData data = new HelpData(null);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)data.getTocOrder().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)data.getHiddenTocs().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)data.getHiddenIndexes().size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)data.isSortOthers());
    }

    @Test
    public void testNullUrlWithBaseTocs() {
        HelpData data = new HelpData(null);
        this.setBaseTocs("/a/b.xml,/c/d.xml");
        List tocOrder = data.getTocOrder();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)tocOrder.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/a/b.xml", tocOrder.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/c/d.xml", tocOrder.get(1));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)data.getHiddenTocs().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)data.getHiddenIndexes().size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)data.isSortOthers());
    }

    @Test
    public void testNullUrlWithHiddenTocs() {
        HelpData data = new HelpData(null);
        this.setIgnoredTocs("/a/b.xml,/c/d.xml");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)data.getTocOrder().size());
        Set hiddenTocs = data.getHiddenTocs();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)hiddenTocs.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)hiddenTocs.contains("/a/b.xml"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)hiddenTocs.contains("/c/d.xml"));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)data.getHiddenIndexes().size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)data.isSortOthers());
    }

    @Test
    public void testNullUrlWithHiddenIndexes() {
        HelpData data = new HelpData(null);
        this.setIgnoredIndexes("/a/b.xml,/c/d.xml");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)data.getTocOrder().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)data.getHiddenTocs().size());
        Set hiddenIndexes = data.getHiddenIndexes();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)hiddenIndexes.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)hiddenIndexes.contains("/a/b.xml"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)hiddenIndexes.contains("/c/d.xml"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)data.isSortOthers());
    }
}

